            <head>
                <link href="https://cdn.datatables.net/v/dt/jszip-3.10.1/dt-2.1.8/b-3.1.2/b-html5-3.1.2/r-3.0.3/datatables.min.css" rel="stylesheet">
            </head>

            <style>
                .tableFixHead {
                    overflow-y: auto;
                    height: 450px;
                }

                .tableFixHead thead th {
                    position: sticky;
                    top: 0;
                }

                /* Just common table stuff. Really. */
                table {
                    border-collapse: collapse;
                    width: 100%;
                }

                th,
                td {
                    padding: 8px 16px;
                }

                th {
                    background: #eee;
                }

                #text-permissao th {
                    background: white;
                }

                .main-row {
                    padding-left: 10px;
                    padding-right: 10px;
                }

                .main-col-12 {
                    padding: 20px;
                    background-color: white;
                    border-radius: 5px;
                }

                .dataTables_wrapper .row {
                    width: 101%;
                    margin-bottom: 15px;
                }

                .pagination {
                    margin-top: 0px;
                }

                .dataTables_length label select {
                    margin-left: 10px;
                    margin-right: 10px;
                }

                .row-c {
                    width: 110%;
                    margin-bottom: 15px;
                }

                .btn-primary {
                    background-color: #033557;
                    border-color: #033557;
                }

                .btn-primary:hover {
                    background-color: #033557;
                    border-color: #033557;
                }

                .btn-primary:focus {
                    background-color: #033557;
                    border-color: #033557;
                }

                .btn-primary:not(:disabled):not(.disabled).active,
                .btn-primary:not(:disabled):not(.disabled):active,
                .show>.btn-primary.dropdown-toggle {
                    background-color: #033557;
                    border-color: #033557;
                }

                .pagination>.active>a {
                    background-color: #033557;
                }

                .pagination>.active>a:hover {
                    background-color: #033557;
                }

                .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
                    background: white;
                    border-color: white;
                }

                .btn-info-red {
                    float: right;
                    margin-right: 15px;
                    width: 25px;
                    height: 25px;
                    border: 2px solid black;
                    border-radius: 50%;
                    text-align: center;
                    color: red;
                    cursor: pointer;
                }

                .btn-info-red:hover {
                    color: black;
                }

                .swal2-title {
                    font-size: 25px;
                }

                .swal2-content {
                    font-size: 20px;
                }

                .swal2-styled.swal2-confirm {
                    font-size: 15px;
                }

                @media (min-width: 500px) {
                    .swal2-popup.swal2-modal.swal2-icon-info.swal2-show {
                        width: 40%;
                    }
                }

                .see-pass {
                    width: 10%;
                    margin-left: -4px;
                    margin-top: -2px;
                    border-top-left-radius: 0;
                    border-bottom-left-radius: 0;
                }

                .passwd {
                    width: 50%;
                    display: inline;
                    border-top-right-radius: 0;
                    border-bottom-right-radius: 0;
                }

                .encurtar {
                    display: -webkit-box;
                    overflow: hidden;
                    -webkit-line-clamp: 1;
                    -webkit-box-orient: vertical;
                    word-break: break-word;
                    line-height: 11px !important;
                }

                .modalCard {
                    width: 100%;
                    height: 100%;
                    overflow-y: hidden;
                    padding: 20px;
                    border-radius: 5px;
                    background-color: #00000073;
                    overflow-x: hidden;
                    position: absolute;
                    top: 0;
                    left: 0;
                    z-index: 99;
                    display: none;
                }
            </style>

            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="container-fluid">

                <div class="row main-row">
                    <div class="col-md-12 main-col-12">

                        <div class="row main-row">
                            <?php /*if($this->session->userdata('editar') == 1 ){*/ ?>
                            <div style="margin-bottom: 10px">
                                <a class="btn btn-primary" style='color: white' data-toggle="modal" data-target="#modalItem" onclick="newForm()">Novo Vale</a>
                            </div>

                            <div>
                                &nbsp;&nbsp;<a class="btn btn-primary" data-toggle="modal" data-target="#modalFiltro"><em class="fa fa-file-o"></em>&nbsp;&nbsp;PDF</a>
                            </div>
                            <div>
                                &nbsp;&nbsp;<a class="btn btn-primary" data-toggle="modal" data-target="#modalFiltroEXCEL"><em class="fa fa-file-o"></em>&nbsp;&nbsp;EXCEL</a>
                            </div>
                        </div>
                        <?php /*}*/ ?>
                        <?php if ($erro != null) { ?>
                            <div class="row" style="margin-bottom: 20px">
                                <div class="col-md-12">
                                    <h3 class="text-danger">Erro: A senha informada estava incorreta, por favor tente novamente!</h3>
                                </div>
                            </div>
                        <?php } ?>

                        <div class="input-group-append" style="position: absolute; right: 22px; height: 30px;top:75px; z-index: 2;">
                            <span style="background: white; border: 1px solid lightgrey" class="input-group-text" id="basic-addon2"><i style="font-size: 18px; cursor: pointer; color: #033557!important;" class="fa fa-search" aria-hidden="true"></i></span>
                        </div>

                        <div class="tableFixHead" style="height: auto;">
                            <table id="myTableFunc" class="table table-hover table-bordered">
                                <thead>
                                    <tr>
                                        <th style="width: 3%">Solicitação</th>
                                        <th style="width: 5%">Validade</th>
                                        <th style="width: 15%">Motorista</th>
                                        <th style="width: 15%">Fornecedor</th>
                                        <!--<th style="width: 10%">Valor</th>-->
                                        <th style="width: 5%">Qtd</th>
                                        <!--'<th style="width: 15%">Descrição</th>-->
                                        <th style="width: 13%">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($itens as $itm) { ?>
                                        <tr>
                                            <td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo ucwords('AB' . str_pad($itm['vr_solicitacao_id'], 6, '0', STR_PAD_LEFT)); ?>">
                                                    <?php echo ucwords(str_pad($itm['vr_solicitacao_id'], 6, '0', STR_PAD_LEFT)) ?>
                                                </div>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <?php echo ($itm['vr_data_validade'] != null) ? date('d/m/Y', strtotime($itm['vr_data_validade'])) : '' ?>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo $itm['motorista_nome'] ?>">
                                                    <?php echo strtolower($itm['motorista_nome']) ?>
                                                </div>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo $itm['fornecedor_nome'] ?>">
                                                    <?php echo $itm['fornecedor_nome'] ?>
                                                </div>
                                            </td>
                                            <!--<td style="vertical-align: middle;">
                                                R$ <?php echo number_format((float)$itm['vr_valor'], 2, ',', '.') ?>
                                            </td>-->
                                            <td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo $itm['vr_quantidade'] ?>">
                                                    <?php echo $itm['vr_quantidade'] ?>
                                                </div>
                                            </td>
                                            <!--<td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php //echo $itm['vr_descricao'] ?>">
                                                    <?php //echo $itm['vr_descricao'] ?>
                                                </div>
                                            </td>-->
                                            <td>
                                                <a style="font-size: 10px;padding: 5px 10px" data-toggle="modal" data-target="#modalItem" onclick='openItem(JSON.stringify(<?php echo json_encode($itm) ?>))' class="btn btn-primary btn-modal-toggle mb-1"><i class="fas fa-eye"></i></a>
                                                <a style="font-size: 10px;padding: 5px 10px" href="<?php echo base_url('relatoriosinglevalerefeicao/' . $itm['vr_id'] ) ?>" target="_blank" class="btn btn-primary btn-modal-toggle mb-1"> <i class="fa fa-file-o"></i> </a>
                                                <a style="font-size: 10px;padding: 5px 10px" data-toggle="modal" data-target="#modalItem" onclick='openItem(JSON.stringify(<?php echo json_encode($itm) ?>), true)' class="btn btn-primary"><i class="fas fa-pencil-alt"></i></a>
                                                <?php /*if ($this->session->userdata('excluir') == 1) {*/ ?>
                                                <a data-toggle="modal" data-target="#modalExcluir" class="btn btn-danger" style="font-size: 10px;padding: 5px 10px" onclick="setaExcluir('<?php echo $itm['vr_id']; ?>')"><i class="fas fa-trash"></i></i></a>
                                                <?php //} 
                                                ?>

                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>

            </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->
            <div class="modal fade " id="modalItem">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header" style="text-align: left; justify-content: unset;">
                            <h5 class="modal-title" id="exampleModalLongTitle">Mensagem do Sistema</h5>
                        </div>
                        <form action="<?php echo base_url('valerefeicao/novoitem'); ?>" method="post" id="form_vr">
                            <div class="modal-body">
                                <h4>Vale Refeição</h4>
                                <div class="row">
                                    <input class="inputItem" name="vr_id" id="vr_id" type="hidden">

                                    <div class="col-md-6 form-group">
                                        <label for="vr_fornecedor_cnpj">Fornecedor</label><br>
                                        <select required class="form-control js-example-basic-multiple inputItem select2-input" style="width: 100%" name="vr_fornecedor_cnpj" id="vr_fornecedor_cnpj" required>
                                            <option value="0" selected disabled>-- Selecionar --</option>
                                            <?php foreach ($fornecedores as $fornecedor) { ?>
                                                <option value="<?php echo $fornecedor['fornecedor_cnpj'] ?>"
                                                    <?php /*if ($fornecedor['fornecedor_cnpj'] == $edita['vr_fornecedor_cnpj']) {
                                                        echo "selected";
                                                    } */ ?>>
                                                    <?php echo $fornecedor['fornecedor_nome'] ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="vr_motorista_id">Motorista</label><br>
                                        <select class="js-example-basic-multiple form-control inputItem" style="width: 100%" name="vr_motorista_id" id="vr_motorista_id" required>
                                            <option value="0" selected disabled>-- Selecionar --</option>
                                            <?php foreach ($motoristas as $motorista) { ?>
                                                <option value="<?php echo $motorista['motorista_id'] ?>"
                                                    <?php /*if ($motorista['motorista_id'] == $edita['vr_motorista_id']) {
                                                        echo "selected";
                                                    } */ ?>>
                                                    <?php echo $motorista['motorista_nome'] ?>
                                                </option>
                                            <?php  } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label id="importancia">Validade</label>
                                        <input required class="form-control inputItem" name="vr_data_validade" id="vr_data_validade" type="date">
                                    </div>
                                    
                                    <div class="col-md-4 form-group">
                                        <label id="importancia">Protocolo</label>
                                        <input class="form-control inputItem" name="vr_protocolo" id="vr_protocolo"  >
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label id="vr_quantidade">Quantidade</label>
                                        <input class="form-control " name="vr_quantidade" id="vr_quantidade" type="number" value="1" disabled>
                                    </div>

                                    <div class="col-md-3 form-group" style="display: none">
                                        <label id="importancia">Valor</label>
                                        <div class="form-control body_value">
                                            <div class="row">
                                                <label class="col-md-3">R$</label>
                                                <input disabled class=" col-md-8 " style="border-width:0" name="vr_valor" id="vr_valor" type="text">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12 form-group">
                                        <label id="importancia">Descrição</label>
                                        <textarea required class="form-control inputItem" name="vr_descricao" id="vr_descricao" type="textarea" rows="3"></textarea>
                                    </div>

                                </div>
                            </div>
                            <div class="modal-footer" style="position: relative">
                                <button class="btn btn-danger" data-dismiss="modal" type="button" onclick="closemodal()">Cancelar</button>
                                <button class="btn btn-primary" id="btn-salvar" type="submit">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="modalCategoria" tabindex="-1" role="dialog" aria-labelledby="modalCategoriaTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header" style="text-align: left; justify-content: unset;">
                            <h5 class="modal-title" id="exampleModalLongTitle">Mensagem do Sistema</h5>
                        </div>
                        <form action="<?php echo base_url('checklist/novacategoria'); ?>" method="post">
                            <div class="modal-body">
                                <h4>Informar a nova Categoria</h4>
                                <div class="row">
                                    <div class="col-md-7">
                                        <label id="categoria">Categória</label>
                                        <input class="form-control" name="categoria" id="categoria" type="text" placeholder="Nome da Categoria">
                                    </div>
                                    <div class="col-md-5">
                                        <label id="importancia">Nível de Importância</label>
                                        <input class="form-control" name="importancia" id="importancia" type="number" placeholder="Nível de Importância" min="1" max="10">
                                    </div>
                                </div>

                            </div>
                            <div class="modal-footer" style="position: relative">
                                <button class="btn btn-primary" type="submit" style="position: absolute; top: 15px; left: 15px; color: white; float: left">Salvar</button>
                                <button class="btn btn-danger" data-dismiss="modal">Cancelar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="modalFiltroEXCEL" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">

                        <div class="modal-header">
                            <div class="row row-c">
                                <div class="col-md-10">
                                    <h4 class="modal-title">Filtros</h4>
                                </div>
                                <div class="col-md-2 text-right">
                                    <button type="button" class="close" onclick="hideFiltro()" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <form action="<?php echo base_url('relatorioexcelvalerefeicao') ?>" method="post" target="_blank">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-6 form-group">
                                        <label id="importancia">Data inicial</label>
                                        <input class="form-control" onchange='dateIsOlder("inicioE", "fimE")' id="inicioE" name="inicio" type="date">
                                    </div>
                                    <div class="col-md-6 form-group">
                                        <label id="importancia">Data final</label>
                                        <input class="form-control" onchange='dateIsOlder("inicioE", "fimE")' id="fimE" name="fim" type="date">
                                    </div>
                                    
                                    <div class="col-md-6 form-group">
                                        <label for="motorista_id" class="form-label">Motorista</label>
                                        <select class="form-control select2-input_filtrosE" style="width:100%;" name="motorista_id" >
                                            <option value="todas" selected >-- Todos --</option>
                                            <?php foreach ($motoristas as $moto) { ?>
                                                <option value="<?php echo $moto['motorista_id']; ?>"> <?php echo $moto['motorista_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="fornecedor_cnpj" class="form-label">Fornecedor</label>
                                        <select class="form-control select2-input_filtrosE" style="width:100%;" name="fornecedor_cnpj">
                                            <option value="todas" selected >-- Todos --</option>
                                            <?php foreach ($fornecedores as $forn) { ?>
                                                <option value="<?php echo $forn['fornecedor_cnpj']; ?>"> <?php echo $forn['fornecedor_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger" onclick="hideFiltro()">Cancelar</button>
                                &nbsp;&nbsp;
                                <button type="submit" class="btn btn-primary">Gerar EXCEL</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <div class="modal fade" id="modalFiltro" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">

                        <div class="modal-header">
                            <div class="row row-c">
                                <div class="col-md-10">
                                    <h4 class="modal-title">Filtros</h4>
                                </div>
                                <div class="col-md-2 text-right">
                                    <button type="button" class="close" onclick="hideFiltro()" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <form action="<?php echo base_url('relatoriovalerefeicao') ?>" method="post" target="_blank">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-6 form-group">
                                        <label id="importancia">Data inicial</label>
                                        <input class="form-control" onchange='dateIsOlder("inicio", "fim")' id="inicio" name="inicio" type="date">
                                    </div>
                                    <div class="col-md-6 form-group">
                                        <label id="importancia">Data final</label>
                                        <input class="form-control" onchange='dateIsOlder("inicio", "fim")' id="fim" name="fim" type="date">
                                    </div>
                                    <div class="col-md-6 form-group">
                                        <label for="motorista_id" class="form-label">Motorista</label>
                                        <select class="form-control select2-input_filtros" style="width:100%;" name="motorista_id" >
                                            <option value="todas" selected >-- Todos --</option>
                                            <?php foreach ($motoristas as $moto) { ?>
                                                <option value="<?php echo $moto['motorista_id']; ?>"> <?php echo $moto['motorista_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="fornecedor_cnpj" class="form-label">Fornecedor</label>
                                        <select class="form-control select2-input_filtros" style="width:100%;" name="fornecedor_cnpj">
                                            <option value="todas" selected >-- Todos --</option>
                                            <?php foreach ($fornecedores as $forn) { ?>
                                                <option value="<?php echo $forn['fornecedor_cnpj']; ?>"> <?php echo $forn['fornecedor_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger" onclick="hideFiltro()">Cancelar</button>
                                &nbsp;&nbsp;
                                <button type="submit" class="btn btn-primary">Gerar PDF</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <div class="modal fade" id="modalExcluir" tabindex="-1" role="dialog" aria-labelledby="modalExcluirTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <form action="<?php echo base_url('valerefeicao/deletar') ?>" method="post">
                        <input type="hidden" name="vr_id" id="vr_id_delete">
                        <div class="modal-content">
                            <div class="modal-header" style="text-align: left; justify-content: unset;">
                                <h5 class="modal-title" id="exampleModalLongTitle">Mensagem do Sistema</h5>
                            </div>
                            <div class="modal-body">
                                <h4>Deseja realmente excluir este item?</h4>
                            </div>
                            <div class="modal-footer" style="position: relative">
                                <button class="btn btn-primary" style="position: absolute; top: 15px; left: 15px; color: white; float: left" onclick="senha()">&nbsp&nbspSim&nbsp&nbsp</button>
                                <button class="btn btn-danger" data-dismiss="modal">&nbsp&nbspNão&nbsp&nbsp</button>
                                <br><br>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <script>
                function dateIsOlder(input1, input2) {
                    const inicio = new Date($('#'+input1).val());
                    const fim = new Date($('#'+input2).val());
                    if (fim < inicio) {
                        alert('A data final deve ser maior que a inicial');
                        $('#'+input1).val('');
                        $('#'+input2).val('');
                    }
                }

                function newForm() {
                    $('#btn-salvar').css('display', 'block');

                    const inputs = document.querySelectorAll('.inputItem');

                    $('#vr_fornecedor_cnpj').val('0');
                    $('#vr_motorista_id').val('0');

                    $('#vr_fornecedor_cnpj').trigger('change');
                    $('#vr_motorista_id').trigger('change');

                    inputs.forEach(input => {
                        if(input.id !== 'vr_quantidade')
                        input.value = '';
                    });
                    toggleInputs(true)

                    $('#vr_quantidade').attr('disabled', true);
                }

                function toggleInputs(status) {
                    const inputs = document.querySelectorAll('.inputItem');
                    inputs.forEach(input => {
                        if (status) {
                            input.disabled = false;
                        } else {
                            input.disabled = true;
                        }
                    });
                }

                function openItem(item, edit) {

                    if (edit) {
                        document.getElementById('vr_id').disabled = false;
                        document.getElementById('vr_data_validade').disabled = false;
                        document.getElementById('vr_descricao').disabled = false;
                        document.getElementById('vr_fornecedor_cnpj').disabled = false;
                        document.getElementById('vr_motorista_id').disabled = false;
                        //document.getElementById('vr_quantidade').disabled = false;
                        //document.getElementById('vr_valor').disabled = false;
                        document.getElementById('vr_protocolo').disabled = false;


                        $('.body_value').css('background-color', 'white');
                        $('#btn-salvar').css('display', 'block');

                    } else {
                        document.getElementById('vr_id').disabled = true;
                        document.getElementById('vr_data_validade').disabled = true;
                        document.getElementById('vr_descricao').disabled = true;
                        document.getElementById('vr_fornecedor_cnpj').disabled = true;
                        document.getElementById('vr_motorista_id').disabled = true;
                        //document.getElementById('vr_quantidade').disabled = true;
                        //document.getElementById('vr_valor').disabled = true;
                        document.getElementById('vr_protocolo').disabled = true;
                            
                        $('.body_value').css('background-color', '#eee');
                        $('#btn-salvar').css('display', 'none');
                    }

                    setTimeout(() => {
                        const values = JSON.parse(item);
                        document.getElementById('vr_id').value = values?.vr_id;
                        document.getElementById('vr_data_validade').value = values?.vr_data_validade;
                        document.getElementById('vr_descricao').value = values?.vr_descricao;
                        document.getElementById('vr_quantidade').value = values?.vr_quantidade;
                        //document.getElementById('vr_valor').value = values?.vr_valor;
                        document.getElementById('vr_protocolo').value = values?.vr_protocolo;

                        $('#vr_fornecedor_cnpj').val(values?.vr_fornecedor_cnpj).trigger('change');
                        $('#vr_motorista_id').val(values?.vr_motorista_id).trigger('change');


                    }, 500);

                }

            </script>

            <script>
                $(document).ready(function() {

                    document.getElementById('vr_data_validade').value = "<?php echo date('Y-m-d'); ?>";

                    $('#vr_valor').mask('000000000000000.00', {
                        reverse: true
                    });

                    $('.js-example-basic-multiple').select2({
                        theme: "bootstrap",
                        dropdownParent: $('#modalItem')
                    });

                    $('.select2-input_filtros').select2({
                        theme: "bootstrap",
                        dropdownParent: $('#modalFiltro')
                    })

                    $('.select2-input_filtrosE').select2({
                        theme: "bootstrap",
                        dropdownParent: $('#modalFiltroEXCEL')
                    })

                    $('#myTableFunc').DataTable({
                        layout: {
                            topStart: 'buttons',
                        },
                        "order": [
                            [0, "desc"]
                        ],
                        "buttons": [{
                            extend: 'excelHtml5',
                            text: 'EXCEL',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5] // Define quais colunas exportar (a coluna de índice 3 será omitida)
                            }
                        }],
                        "language": {
                            "lengthMenu": "Mostrando _MENU_",
                            "zeroRecords": "Nada encontrado- refaça sua busca",
                            "info": "Mostrando _PAGE_ de _PAGES_",
                            "infoEmpty": "Sem registros disponíves",
                            "infoFiltered": "(filtrado _MAX_ dos registros totais)",
                            "sSearch": "Procurar:",
                            "searchPlaceholder": "Digite sua busca",
                            "paginate": {
                                "previous": "Anterior",
                                "next": "Próximo",
                            }
                        },
                        "columns": [
                            {
                                "Solicitação": "first",
                                "orderable": true
                            },
                            {
                                "Validade": "first",
                                "orderable": true
                            },
                            {
                                "Motorista": "second",
                                "orderable": true
                            },
                            {
                                "Fornecedor": "third",
                                "orderable": true
                            },
                            /*{
                                "Valor": "fourth",
                                "orderable": true
                            },*/
                            {
                                "Qtd": "fourth",
                                "orderable": true
                            },
                            /*{
                                "Descrição": "fourth",
                                "orderable": true
                            },*/
                            {
                                "Ação": "fourth",
                                "orderable": false
                            },
                        ],
                    });

                    $('.buttons-excel').addClass('hidden');
                    $('#btn-excel').on('click', function() {
                        $('.buttons-excel').click();
                    })
                });
            </script>

            <script>
                function setaExcluir(id) {
                    document.getElementById('vr_id_delete').value = id;
                }
            </script>

            <script>
                function hideFiltro() {
                    //$('#filtro_marca').val('').change();
                    //$('#filtro_situacao').val('').change();
                    
                    $('#modalFiltro').modal('hide');
                    $('#modalFiltroEXCEL').modal('hide');
                }
                $('#modalFiltro').on('hidden.bs.modal', function() {
                    hideFiltro();
                });
            </script>