<style>
    .span-data {
        font-weight: bold;
    }

    .td-impar {
        background-color: #eee !important;
    }

    .inside-table {
        width: 100%;
    }

    .inside-table tr {
        font-size: 11px;
    }

    .inside-table tr:hover {
        background-color: #eee !important;
    }

    .inside-table td {
        border: 0;
    }

    .inside-table th {
        border: 0;
        border-bottom: 0px !important;
    }

    .sep-tr {
        border-top: 2px solid lightgrey;
    }

    .title-inside {
        font-weight: bold;
    }
</style>
<div class="row">
    <div class="col-md-12" id="main" style="padding: 20px 40px">
        <br><br>
        <div class="row">
            <div class="col-md-12 form-group text-center">
                <button onclick="pdf()" id="pdf" class="btn btn-primary" style="float: left">.PDF</button>
                <img src="<?php echo base_url('resources/imgs/logotemp.png') ?>" style="width: 35%; height: auto">
                <br><br>
                <h3 style="font-weight: bold">
                    ABASTECIMENTOS 
                    <?php
                    date_default_timezone_set('America/Sao_Paulo');
                    if (!empty($filtros['inicio'])) {
                        echo ' de ' . date('d/m/Y', strtotime($filtros['inicio'])) . ' a ' . date('d/m/Y', strtotime($filtros['fim']));
                    } else {
                        echo date('d/m/Y');
                    }  ?>
                </h3>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 form-group">
                <table class="table table-hover table-bordered" id="example2">
                    <thead>
                        <tr style="background-color: #eee;">
                            <th style="width: 6%">Solicitação</th>
                            <th style="width: 11%">Data hora</th>
                            <th style="width: 18%">Fornecedor</th>
                            <th style="width: 8%">Veículo</th>
                            <th style="width: 16%">Motorista</th>
                            <th style="width: 5%">Litros</th>
                            <th style="width: 5%">Combustível</th>
                            <th style="width: 5%">Quitada</th>
                            <th style="width: 8%">Valor</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $quantidadeTotal = 0;
                        $total = 0;

                        foreach ($itens as $c) { ?>
                            <tr>
                                <td><?php echo $c['abst_solicitacao_abastecimento_id']    ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($c['abst_data_hora'])) ?></td>
                                <td><?php echo $c['fornecedor_nome'] ?></td>
                                <td><?php echo $c['veiculo']['placa'] ?></td>
                                <td><?php echo $c['motorista_nome'] ?></td>
                                <td><?php echo $c['abst_quantidade_litros'] ?></td>
                                <td><?php echo $c['abst_combustivel'] ?></td>
                                <td><?php echo $c['abst_quitada'] ?></td>
                                <td>R$ <?php echo number_format($c['abst_valor'], 2, ',', '.') ?></td>
                            </tr>
                        <?php  $quantidadeTotal += $c['abst_quantidade_litros']; $total += $c['abst_valor']; } ?>
                    </tbody>
                </table>

                <br><br>

                <p class="text-right"><label>Quitada: <?= $quitada ?> </label> <label class="ml-3">Não quitada: <?= $naoquitada ?> </label> <label class="ml-3">Litros: <?= $quantidadeTotal ?> </label></label></p>
                <p class="text-right"><label class="ml-3">Total: R$ <?= number_format($total, 2, ',', '.') ?></label></p>

            </div>
        </div>

        <footer id="footer" style="position: fixed; bottom: 0; text-align: center; width: 100%; margin-bottom: -30px; display: none">
            <div class="row">
                <div class="col-md-5 text-left">
                    <p><b>Abastecimentos | <?php echo date('d/m/Y - H:i:s') ?></b></p>
                </div>
                <div class="col-md-6 text-right">
                    <p>Gerenciamento de Frotas | N Soluções</p>
                </div>
            </div>
            <br><br>
        </footer>

    </div>
</div>

<script>
    function pdf() {
        $('#pdf').css('display', 'none');
        $('#footer').css('display', 'block');
        window.print();
        $('#footer').css('display', 'none');
        $('#pdf').css('display', 'block');
    }

    $(document).ready(function () {

$('#example2').DataTable({
                layout: {
                    topStart: 'buttons',
                },
                "order": [
                    [0, "desc"]
                ],
                "buttons": [{
                    extend: 'excelHtml5',
                    text: 'EXCEL',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6, 7,8] // Define quais colunas exportar (a coluna de índice 3 será omitida)
                    }
                }],
                "language": {
                    "lengthMenu": "Mostrando _MENU_",
                    "zeroRecords": "Nada encontrado- refaça sua busca",
                    "info": "Mostrando _PAGE_ de _PAGES_",
                    "infoEmpty": "Sem registros disponíves",
                    "infoFiltered": "(filtrado _MAX_ dos registros totais)",
                    "sSearch": "Procurar:",
                    "searchPlaceholder": "Digite sua busca",
                    "paginate": {
                        "previous": "Anterior",
                        "next": "Próximo",
                    }
                },
                
            });

            $('.buttons-excel').click();

            setTimeout(function () {
                window.close();
            }, 1000)

});
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/v/dt/jszip-3.10.1/dt-2.1.8/b-3.1.2/b-html5-3.1.2/r-3.0.3/datatables.min.js"></script>
