  <!-- BS Stepper -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bs-stepper/dist/css/bs-stepper.min.css">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="<?php echo base_url('resources/');?>dropzone/min/dropzone.min.css">


    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                </div>
                <div class="card-body p-0">
                    <div class="bs-stepper">
                        <div class="bs-stepper-header" role="tablist">
                            <!-- your steps here -->
                            <div class="step" data-target="#info-part">
                                <button type="button" class="step-trigger" role="tab" aria-controls="info-part" id="info-part-trigger">
                                    <span class="bs-stepper-circle">1</span>
                                    <span class="bs-stepper-label">Informações Gerais</span>
                                </button>
                            </div>

                            <div class="line"></div>
                            <div class="step" data-target="#documentos-part">
                                <button type="button" class="step-trigger" role="tab" aria-controls="documentos-part" id="documentos-part-trigger">
                                    <span class="bs-stepper-circle">2</span>
                                    <span class="bs-stepper-label">Documentos</span>
                                </button>
                            </div>
                            
                            <div class="line"></div>
                            <div class="step" data-target="#cabineinterna-part">
                                <button type="button" class="step-trigger" role="tab" aria-controls="cabineinterna-part" id="cabineinterna-part-trigger">
                                    <span class="bs-stepper-circle">3</span>
                                    <span class="bs-stepper-label">Cabine Interna</span>
                                </button>
                            </div>
                            
                            <div class="line"></div>
                            <div class="step" data-target="#sistemaeletrico-part">
                                <button type="button" class="step-trigger" role="tab" aria-controls="sistemaeletrico-part" id="sistemaeletrico-part-trigger">
                                    <span class="bs-stepper-circle">4</span>
                                    <span class="bs-stepper-label">Sistema Elétrico</span>
                                </button>
                            </div>
                            
                            <div class="line"></div>
                            <div class="step" data-target="#cabineexterna-part">
                                <button type="button" class="step-trigger" role="tab" aria-controls="cabineexterna-part" id="cabineexterna-part-trigger">
                                    <span class="bs-stepper-circle">5</span>
                                    <span class="bs-stepper-label">Cabine Externa</span>
                                </button>
                            </div>
                            
                            <div class="line"></div>
                            <div class="step" data-target="#cabinesuplementar-part">
                                <button type="button" class="step-trigger" role="tab" aria-controls="cabinesuplementar-part" id="cabinesuplementar-part-trigger">
                                    <span class="bs-stepper-circle">6</span>
                                    <span class="bs-stepper-label">Cabine Suplementar</span>
                                </button>
                            </div>
                            
                            <div class="line"></div>
                            <div class="step" data-target="#munck-part">
                                <button type="button" class="step-trigger" role="tab" aria-controls="munck-part" id="munck-part-trigger">
                                    <span class="bs-stepper-circle">7</span>
                                    <span class="bs-stepper-label">Munck</span>
                                </button>
                            </div>
                            
                            <div class="line"></div>
                            <div class="step" data-target="#carroceria-part">
                                <button type="button" class="step-trigger" role="tab" aria-controls="carroceria-part" id="carroceria-part-trigger">
                                    <span class="bs-stepper-circle">8</span>
                                    <span class="bs-stepper-label">Carroceria</span>
                                </button>
                            </div>
                            
                            <div class="line"></div>
                            <div class="step" data-target="#pneus-part">
                                <button type="button" class="step-trigger" role="tab" aria-controls="pneus-part" id="pneus-part-trigger">
                                    <span class="bs-stepper-circle">9</span>
                                    <span class="bs-stepper-label">Pneus</span>
                                </button>
                            </div>

                            <div class="line"></div>
                            <div class="step" data-target="#fotos-part">
                                <button type="button" class="step-trigger" role="tab" aria-controls="fotos-part" id="fotos-part-trigger">
                                    <span class="bs-stepper-circle">10</span>
                                    <span class="bs-stepper-label">Fotos</span>
                                </button>
                            </div>

                        </div>
                        
                        <div class="bs-stepper-content">
                        <!-- your steps content here -->
                            <div id="info-part" class="content" role="tabpanel" aria-labelledby="info-part-trigger">
                                <div class="form-group">
                                    <label for="local">Local</label>
                                    <input type="text" class="form-control" id="local" name="local"  placeholder="Local do preenchimento do checklist">
                                    <em id="local_erro" style="display:none; margin-top:6px; padding:0 1px; font-style:normal; font-size:11px; line-height:15px; color:#D56161;"></em>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="data">Data</label>
                                            <input type="date" class="form-control" id="data" name="data" placeholder="Data">
                                            <em id="data_erro" style="display:none; margin-top:6px; padding:0 1px; font-style:normal; font-size:11px; line-height:15px; color:#D56161;"></em>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="data">Frota</label>
                                            <select class="form-control select2-check" name="frota" id="frota" style="width:100%">
                                                <option value="-1" selected disabled>Selecione uma frota</option>
                                                <?php foreach($frota as $frt){?>
                                                <option value="<?php echo $frt['frota_id'];?>"><?php echo $frt['frota_codigo']." - ".$frt['frota_placa'];?></option>
                                                <?php } ?>
                                            </select>
                                            <em id="frota_erro" style="display:none; margin-top:6px; padding:0 1px; font-style:normal; font-size:11px; line-height:15px; color:#D56161;"></em>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="data">Hodômetro</label>
                                            <input type="number" class="form-control" id="hodometro" name="hodometro" placeholder="Km">
                                            <em id="hodometro_erro" style="display:none; margin-top:6px; padding:0 1px; font-style:normal; font-size:11px; line-height:15px; color:#D56161;"></em>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="local">Responsável pela Inspeção:</label>
                                    <input type="text" class="form-control" id="responsavel" name="responsavel"  placeholder="Responsavel pelo preenchimento do checklist">
                                    <em id="responsavel_erro" style="display:none; margin-top:6px; padding:0 1px; font-style:normal; font-size:11px; line-height:15px; color:#D56161;"></em>
                                </div>
                                <div class="form-group">
                                    <label for="local">Cliente:</label>
                                    <select class="form-control select2-check" name="cliente" id="cliente" style="width:100%">
                                        <option value="" selected disabled>Selecione um cliente</option>
                                        <?php foreach($cliente as $cli){?>
                                        <option value="<?php echo $cli['cliente_cpfcnpj'];?>"><?php echo $cli['cliente_nome'];?></option>
                                        <?php } ?>
                                    </select>
                                    <em id="cliente_erro" style="display:none; margin-top:6px; padding:0 1px; font-style:normal; font-size:11px; line-height:15px; color:#D56161;"></em>
                                </div>
                                <button class="btn btn-primary" onclick="cklistNew()">Próximo</button>
                            </div>

                            <div id="documentos-part" class="content" role="tabpanel" aria-labelledby="documentos-part-trigger">
                            <?php foreach($documentos as $doc){?>
                                <div class="row">
                                    <div class="col-md-2 d-flex justify-content-center align-items-center">
                                        <button type="button" class="btn btn-success" id="conf-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" ><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm10.03 4.97a.75.75 0 0 1 .011 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.75.75 0 0 1 1.08-.022z"/>
                                        </svg>&nbsp; Confere</button>
                                        <button type="button" class="btn btn-danger"  id="prob-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" style="display:none"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm3.354 4.646L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 1 1 .708-.708z"/>
                                        </svg>&nbsp; Problema</button>
                                        <input type="hidden" id="<?php echo $doc['item_id']?>-confirm" name="<?php echo $doc['item_id']?>-confirm" value="0">
                                    </div>
                                    <div class="col-md-10">
                                        <label for="<?php echo $doc['item_id']?>-confirm"><?php echo $doc['item_nome']?>:</label><br>
                                        <span>Observacão</span>
                                        <p><textarea class="form-control" id="<?php echo $doc['item_id']?>-obs" name="<?php echo $doc['item_id']?>-obs" style="display:none"></textarea></p>
                                    </div>
                                </div>
                                <hr size="8" width="90%" color="red">
                            <?php }?>
                            
                                <button class="btn btn-primary" onclick="stepper.previous()">Anterior</button>
                                <button class="btn btn-primary" onclick="saveChklst('documentos')">Próximo</button>
                            </div>
                            
                            <div id="cabineinterna-part" class="content" role="tabpanel" aria-labelledby="cabineinterna-part-trigger">
                            
                            <?php foreach($cabineinterna as $doc){?>
                                <div class="row">
                                    <div class="col-md-2 d-flex justify-content-center align-items-center">
                                        <button type="button" class="btn btn-success" id="conf-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" ><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm10.03 4.97a.75.75 0 0 1 .011 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.75.75 0 0 1 1.08-.022z"/>
                                        </svg>&nbsp; Confere</button>
                                        <button type="button" class="btn btn-danger"  id="prob-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" style="display:none"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm3.354 4.646L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 1 1 .708-.708z"/>
                                        </svg>&nbsp; Problema</button>
                                        <input type="hidden" id="<?php echo $doc['item_id']?>-confirm" name="<?php echo $doc['item_id']?>-confirm" value="0">
                                    </div>
                                    <div class="col-md-10">
                                        <label for="<?php echo $doc['item_id']?>-confirm"><?php echo $doc['item_nome']?>:</label><br>
                                        <span>Observacão</span>
                                        <p><textarea class="form-control" id="<?php echo $doc['item_id']?>-obs" name="<?php echo $doc['item_id']?>-obs" style="display:none"></textarea></p>
                                    </div>
                                </div>
                                <hr size="8" width="90%" color="red">
                            <?php }?>
                                
                                <button class="btn btn-primary" onclick="stepper.previous()">Anterior</button>
                                <button class="btn btn-primary" onclick="saveChklst('cabineinterna')">Próximo</button>
                            </div>
                            
                            <div id="sistemaeletrico-part" class="content" role="tabpanel" aria-labelledby="sistemaeletrico-part-trigger">
                                
                                <?php foreach($sistemaeletrico as $doc){?>
                                <div class="row">
                                    <div class="col-md-2 d-flex justify-content-center align-items-center">
                                        <button type="button" class="btn btn-success" id="conf-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" ><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm10.03 4.97a.75.75 0 0 1 .011 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.75.75 0 0 1 1.08-.022z"/>
                                        </svg>&nbsp; Confere</button>
                                        <button type="button" class="btn btn-danger"  id="prob-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" style="display:none"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm3.354 4.646L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 1 1 .708-.708z"/>
                                        </svg>&nbsp; Problema</button>
                                        <input type="hidden" id="<?php echo $doc['item_id']?>-confirm" name="<?php echo $doc['item_id']?>-confirm" value="0">
                                    </div>
                                    <div class="col-md-10">
                                        <label for="<?php echo $doc['item_id']?>-confirm"><?php echo $doc['item_nome']?>:</label><br>
                                        <span>Observacão</span>
                                        <p><textarea class="form-control" id="<?php echo $doc['item_id']?>-obs" name="<?php echo $doc['item_id']?>-obs" style="display:none"></textarea></p>
                                    </div>
                                </div>
                                <hr size="8" width="90%" color="red">
                            <?php }?>
                                
                                <button class="btn btn-primary" onclick="stepper.previous()">Anterior</button>
                                <button class="btn btn-primary" onclick="saveChklst('sistemaeletrico')">Próximo</button>
                            </div>
                            
                            <div id="cabineexterna-part" class="content" role="tabpanel" aria-labelledby="cabineexterna-part-trigger">
                                
                                <?php foreach($cabineexterna as $doc){?>
                                <div class="row">
                                    <div class="col-md-2 d-flex justify-content-center align-items-center">
                                        <button type="button" class="btn btn-success" id="conf-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" ><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm10.03 4.97a.75.75 0 0 1 .011 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.75.75 0 0 1 1.08-.022z"/>
                                        </svg>&nbsp; Confere</button>
                                        <button type="button" class="btn btn-danger"  id="prob-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" style="display:none"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm3.354 4.646L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 1 1 .708-.708z"/>
                                        </svg>&nbsp; Problema</button>
                                        <input type="hidden" id="<?php echo $doc['item_id']?>-confirm" name="<?php echo $doc['item_id']?>-confirm" value="0">
                                    </div>
                                    <div class="col-md-10">
                                        <label for="<?php echo $doc['item_id']?>-confirm"><?php echo $doc['item_nome']?>:</label><br>
                                        <span>Observacão</span>
                                        <p><textarea class="form-control" id="<?php echo $doc['item_id']?>-obs" name="<?php echo $doc['item_id']?>-obs" style="display:none"></textarea></p>
                                    </div>
                                </div>
                                <hr size="8" width="90%" color="red">
                            <?php }?>
                                
                                <button class="btn btn-primary" onclick="stepper.previous()">Anterior</button>
                                <button class="btn btn-primary" onclick="saveChklst('cabineexterna')">Próximo</button>
                            </div>
                            
                            <!--<div id="cabineinterna-part" class="content" role="tabpanel" aria-labelledby="cabineinterna-part-trigger">-->
                                
                            <!--    <?php foreach($cabineinterna as $doc){?>-->
                            <!--    <div class="row">-->
                            <!--        <label for="<?php echo $doc['item_id']?>-confirm"><?php echo $doc['item_nome']?>:</label><br>-->
                            <!--        <div class="col-md-4">-->
                            <!--            <button type="button" class="btn btn-success" id="conf-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" >Confere</button>-->
                            <!--            <button type="button" class="btn btn-danger"  id="prob-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" style="display:none">Problema</button>-->
                            <!--            <input type="hidden" id="<?php echo $doc['item_id']?>-confirm" name="<?php echo $doc['item_id']?>-confirm" value="0">-->
                            <!--        </div>-->
                            <!--        <div class="col-md-8">-->
                            <!--            <span>Observacão</span>-->
                            <!--            <p><input type="text" id="<?php echo $doc['item_id']?>-obs" name="<?php echo $doc['item_id']?>-obs" style="display:none"></p>-->
                            <!--        </div>-->
                            <!--    </div>-->
                            <!--    <hr size="8" width="90%" color="red">-->
                            <!--<?php }?>-->
                                
                            <!--    <button class="btn btn-primary" onclick="stepper.previous()">Anterior</button>-->
                            <!--    <button class="btn btn-primary" onclick="saveChklst('cabineinterna')">Próximo</button>-->
                            <!--</div>-->
                            
                            <div id="cabinesuplementar-part" class="content" role="tabpanel" aria-labelledby="cabinesuplementar-part-trigger">
                                
                                <?php foreach($cabinesuplementar as $doc){?>
                                <div class="row">
                                    <div class="col-md-2 d-flex justify-content-center align-items-center">
                                        <button type="button" class="btn btn-success" id="conf-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" ><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm10.03 4.97a.75.75 0 0 1 .011 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.75.75 0 0 1 1.08-.022z"/>
                                        </svg>&nbsp; Confere</button>
                                        <button type="button" class="btn btn-danger"  id="prob-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" style="display:none"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm3.354 4.646L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 1 1 .708-.708z"/>
                                        </svg>&nbsp; Problema</button>
                                        <input type="hidden" id="<?php echo $doc['item_id']?>-confirm" name="<?php echo $doc['item_id']?>-confirm" value="0">
                                    </div>
                                    <div class="col-md-10">
                                        <label for="<?php echo $doc['item_id']?>-confirm"><?php echo $doc['item_nome']?>:</label><br>
                                        <span>Observacão</span>
                                        <p><textarea class="form-control" id="<?php echo $doc['item_id']?>-obs" name="<?php echo $doc['item_id']?>-obs" style="display:none"></textarea></p>
                                    </div>
                                </div>
                                <hr size="8" width="90%" color="red">
                            <?php }?>
                                
                                <button class="btn btn-primary" onclick="stepper.previous()">Anterior</button>
                                <button class="btn btn-primary" onclick="saveChklst('cabinesuplementar')">Próximo</button>
                            </div>
                            
                            <div id="munck-part" class="content" role="tabpanel" aria-labelledby="munck-part-trigger">
                                
                                <?php foreach($munck as $doc){?>
                                <div class="row">
                                    <div class="col-md-2 d-flex justify-content-center align-items-center">
                                        <button type="button" class="btn btn-success" id="conf-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" ><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm10.03 4.97a.75.75 0 0 1 .011 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.75.75 0 0 1 1.08-.022z"/>
                                        </svg>&nbsp; Confere</button>
                                        <button type="button" class="btn btn-danger"  id="prob-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" style="display:none"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm3.354 4.646L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 1 1 .708-.708z"/>
                                        </svg>&nbsp; Problema</button>
                                        <input type="hidden" id="<?php echo $doc['item_id']?>-confirm" name="<?php echo $doc['item_id']?>-confirm" value="0">
                                    </div>
                                    <div class="col-md-10">
                                        <label for="<?php echo $doc['item_id']?>-confirm"><?php echo $doc['item_nome']?>:</label><br>
                                        <span>Observacão</span>
                                        <p><textarea class="form-control" id="<?php echo $doc['item_id']?>-obs" name="<?php echo $doc['item_id']?>-obs" style="display:none"></textarea></p>
                                    </div>
                                </div>
                                <hr size="8" width="90%" color="red">
                            <?php }?>
                                
                                <button class="btn btn-primary" onclick="stepper.previous()">Anterior</button>
                                <button class="btn btn-primary" onclick="saveChklst('munck')">Próximo</button>
                            </div>
                            
                            <div id="carroceria-part" class="content" role="tabpanel" aria-labelledby="carroceria-part-trigger">
                                
                                <?php foreach($carroceria as $doc){?>
                                <div class="row">
                                    <div class="col-md-2 d-flex justify-content-center align-items-center">
                                        <button type="button" class="btn btn-success" id="conf-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" ><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm10.03 4.97a.75.75 0 0 1 .011 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.75.75 0 0 1 1.08-.022z"/>
                                        </svg>&nbsp; Confere</button>
                                        <button type="button" class="btn btn-danger"  id="prob-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" style="display:none"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm3.354 4.646L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 1 1 .708-.708z"/>
                                        </svg>&nbsp; Problema</button>
                                        <input type="hidden" id="<?php echo $doc['item_id']?>-confirm" name="<?php echo $doc['item_id']?>-confirm" value="0">
                                    </div>
                                    <div class="col-md-10">
                                        <label for="<?php echo $doc['item_id']?>-confirm"><?php echo $doc['item_nome']?>:</label><br>
                                        <span>Observacão</span>
                                        <p><textarea class="form-control" id="<?php echo $doc['item_id']?>-obs" name="<?php echo $doc['item_id']?>-obs" style="display:none"></textarea></p>
                                    </div>
                                </div>
                                <hr size="8" width="90%" color="red">
                            <?php }?>
                                
                                <button class="btn btn-primary" onclick="stepper.previous()">Anterior</button>
                                <button class="btn btn-primary" onclick="saveChklst('carroceria')">Próximo</button>
                            </div>
                            
                            <div id="pneus-part" class="content" role="tabpanel" aria-labelledby="pneus-part-trigger">
                                
                            <?php foreach($pneus as $doc){?>
                                <div class="row">
                                    <div class="col-md-2 d-flex justify-content-center align-items-center">
                                        <button type="button" class="btn btn-success" id="conf-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" ><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm10.03 4.97a.75.75 0 0 1 .011 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.75.75 0 0 1 1.08-.022z"/>
                                        </svg>&nbsp; Confere</button>
                                        <button type="button" class="btn btn-danger"  id="prob-<?php echo $doc['item_id']?>" onclick="confirmCheck('<?php echo $doc['item_id']?>')" style="display:none"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-square-fill" viewBox="0 0 16 16">
                                          <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm3.354 4.646L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 1 1 .708-.708z"/>
                                        </svg>&nbsp; Problema</button>
                                        <input type="hidden" id="<?php echo $doc['item_id']?>-confirm" name="<?php echo $doc['item_id']?>-confirm" value="0">
                                    </div>
                                    <div class="col-md-10">
                                        <label for="<?php echo $doc['item_id']?>-confirm"><?php echo $doc['item_nome']?>:</label><br>
                                        <span>Observacão</span>
                                        <p><textarea class="form-control" id="<?php echo $doc['item_id']?>-obs" name="<?php echo $doc['item_id']?>-obs" style="display:none"></textarea></p>
                                    </div>
                                </div>
                                <hr size="8" width="90%" color="red">
                            <?php }?>
                                
                                <button class="btn btn-primary" onclick="stepper.previous()">Anterior</button>
                                <button class="btn btn-primary" onclick="saveChklst('pneus')">Próximo</button>
                            </div>

                            <div id="fotos-part" class="content" role="tabpanel" aria-labelledby="fotos-part-trigger">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="card card-default">
                                            <div class="card-body">
                                                <div id="actions" class="row">
                                                    <div class="col-lg-6">
                                                        <div class="btn-group w-100">
                                                            <span class="btn btn-success col fileinput-button">
                                                                <i class="fas fa-plus"></i>
                                                                <span>Add Fotos</span>
                                                            </span>
                                                            <button type="submit" class="btn btn-primary col start">
                                                                <i class="fas fa-upload"></i>
                                                                <span>Inicia Upload</span>
                                                            </button>
                                                            <button type="reset" class="btn btn-warning col cancel">
                                                                <i class="fas fa-times-circle"></i>
                                                                <span>Cancela Upload</span>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6 d-flex align-items-center">
                                                        <div class="fileupload-process w-100">
                                                            <div id="total-progress" class="progress progress-striped active" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0">
                                                                <div class="progress-bar progress-bar-success" style="width:0%;" data-dz-uploadprogress></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="table table-striped files" id="previews">
                                                    <div id="template" class="row mt-2">
                                                        <div class="col-auto">
                                                            <span class="preview"><img src="data:," alt="" data-dz-thumbnail /></span>
                                                        </div>
                                                        <div class="col d-flex align-items-center">
                                                            <p class="mb-0">
                                                                <span class="lead" data-dz-name></span>
                                                                (<span data-dz-size></span>)
                                                            </p>
                                                            <strong class="error text-danger" data-dz-errormessage></strong>
                                                        </div>
                                                        <div class="col-4 d-flex align-items-center">
                                                            <div class="progress progress-striped active w-100" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0">
                                                                <div class="progress-bar progress-bar-success" style="width:0%;" data-dz-uploadprogress></div>
                                                            </div>
                                                        </div>
                                                        <div class="col-auto d-flex align-items-center">
                                                            <div class="btn-group">
                                                                <button class="btn btn-primary start">
                                                                    <i class="fas fa-upload"></i>
                                                                    <span>Iniciar</span>
                                                                </button>
                                                                <button data-dz-remove class="btn btn-warning cancel">
                                                                    <i class="fas fa-times-circle"></i>
                                                                    <span>Cancelar</span>
                                                                </button>
                                                                <button data-dz-remove class="btn btn-danger delete">
                                                                    <i class="fas fa-trash"></i>
                                                                    <span>Apagar</span>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                                <button class="btn btn-primary" onclick="stepper.previous()">Anterior</button>
                                <button type="submit" class="btn btn-primary" onclick="finish()">Gravar</button>
                            </div>
                            
                            <input type="hidden" id="token" name="token">
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<!-- Bootstrap Switch -->
<script src="<?php echo base_url('resources/');?>bootstrap-switch/js/bootstrap-switch.min.js"></script>
<!-- BS-Stepper -->
<script src="https://cdn.jsdelivr.net/npm/bs-stepper/dist/js/bs-stepper.min.js"></script>
<!-- dropzonejs -->
<script src="<?php echo base_url('resources/');?>dropzone/min/dropzone.min.js"></script>

<!-- Page specific script -->
<script>
    function confirmCheck(id){
        if($('#'+id+'-confirm').val() == 0){
            $('#conf-'+id).hide();
            $('#prob-'+id).show();
            $('#'+id+'-confirm').val(1);
            $('#'+id+'-obs').show();
        }else{
            $('#conf-'+id).show();
            $('#prob-'+id).hide();
            $('#'+id+'-confirm').val(0);
            $('#'+id+'-obs').hide();
        }
    }
</script>

<script>
  $(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    })

    $("input[data-bootstrap-switch]").each(function(){
      $(this).bootstrapSwitch('state', $(this).prop('checked'));
    })

  })
  // BS-Stepper Init
  document.addEventListener('DOMContentLoaded', function () {
    window.stepper = new Stepper(document.querySelector('.bs-stepper'))
  })

  // DropzoneJS Demo Code Start
  Dropzone.autoDiscover = false

  // Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
  var previewNode = document.querySelector("#template")
  previewNode.id = ""
  var previewTemplate = previewNode.parentNode.innerHTML
  previewNode.parentNode.removeChild(previewNode)

  var myDropzone = new Dropzone(document.body, { // Make the whole body a dropzone
    url: "<?php echo base_url('imagem'); ?>", // Set the url
    thumbnailWidth: 80,
    thumbnailHeight: 80,
    parallelUploads: 20,
    previewTemplate: previewTemplate,
    autoQueue: false, // Make sure the files aren't queued until manually added
    previewsContainer: "#previews", // Define the container to display the previews
    clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.
  })

  myDropzone.on("addedfile", function(file) {
    // Hookup the start button
    file.previewElement.querySelector(".start").onclick = function() { myDropzone.enqueueFile(file) }
  })

  // Update the total progress bar
  myDropzone.on("totaluploadprogress", function(progress) {
    document.querySelector("#total-progress .progress-bar").style.width = progress + "%"
  })

  myDropzone.on("sending", function(file,xhr,formData) {
    // Show the tota"l progress bar when upload starts
    formData.append('folder', $("#token").val());
    //formData.append('file', $this.value);
   // formData.append('name', md5(rand(0,9999)));
    document.querySelector("#total-progress").style.opacity = "1"
    // And disable the start button
    file.previewElement.querySelector(".start").setAttribute("disabled", "disabled")
  })

  // Hide the total progress bar when nothing's uploading anymore
  myDropzone.on("queuecomplete", function(progress) {
    document.querySelector("#total-progress").style.opacity = "0"
  })

  // Setup the buttons for all transfers
  // The "add files" button doesn't need to be setup because the config
  // `clickable` has already been specified.
  document.querySelector("#actions .start").onclick = function() {
    myDropzone.enqueueFiles(myDropzone.getFilesWithStatus(Dropzone.ADDED))
  }
  document.querySelector("#actions .cancel").onclick = function() {
    myDropzone.removeAllFiles(true)
  }
  myDropzone.on("success", function() {
    var args = array.prototype.slice.call(arguments);
    
  })
  // DropzoneJS Demo Code End
</script>

<script>
    function cklistNew(){
        var flag = 0;
        
        if($("#local").val() == ""){
            $('#local_erro').html("Campo Obrigatório");
            $('#local_erro').show();
            flag = 1;
        }else{
            $('#local_erro').hide();
        }
        if($("#data").val() == ""){
            $('#data_erro').html("Campo Obrigatório");
            $('#data_erro').show();
            flag = 1;
        }else{
            $('#data_erro').hide();
        }
        if($("#frota").val() == null){
            $('#frota_erro').html("Campo Obrigatório");
            $('#frota_erro').show();
            flag = 1;
        }else{
            $('#frota_erro').hide();
        }
        if($("#hodometro").val() == ""){
            $('#hodometro_erro').html("Campo Obrigatório");
            $('#hodometro_erro').show();
            flag = 1;
        }else{
            $('#hodometro_erro').hide();
        }
        if($("#responsavel").val() == ""){
            $('#responsavel_erro').html("Campo Obrigatório");
            $('#responsavel_erro').show();
            flag = 1;
        }else{
            $('#responsavel_erro').hide();
        }
        if($("#cliente").val() == ""){
            $('#cliente_erro').html("Campo Obrigatório");
            $('#cliente_erro').show();
            flag = 1;
        }else{
            $('#cliente_erro').hide();
        }

        if(flag == 0){

            Swal.fire({
                title: 'Confirma as informações preenchidas?',
                showDenyButton: true,
                showCancelButton: false,
                confirmButtonText: 'Sim, estão corretas.',
                denyButtonText: `Não, vou corrigir...`,
                }).then((result) => {
                    if (result.isConfirmed) {
                        dados = new FormData();
                        dados.append('local', $("#local").val());
                        dados.append('data', $("#data").val());
                        dados.append('frota', $("#frota").val());
                        dados.append('hodometro', $("#hodometro").val());
                        dados.append('responsavel', $("#responsavel").val());
                        dados.append('cliente', $("#cliente").val());
                        dados.append('guia', 1);
                        $.ajax({
                            url: '<?php echo base_url('step1'); ?>',
                            method: 'post',
                            data: dados,
                            processData: false,
                            contentType: false,
                            dataType: 'json',
                            beforeSend: function(){
                                $("#formChkList").css("display", "none");
                                $("#formChkList").empty();
                                $("#helper-part").css("display", "block");
                            },
                            error: function(xhr, status, error) {
                                console.log(error);
                                console.log(status);
                                console.log(xhr);
                            },
                            success: function(data) {
                                stepper.next()
                                $("#formChkList").append(data.div);
                                //console.log(data.token);

                                document.addEventListener('DOMContentLoaded', function () {
                                    window.stepper = new Stepper(document.querySelector('.bs-stepper'))
                                })
                                
                                $("#helper-part").css("display", "none");
                                $("#formChkList").css("display", "block");
                                $("#token").val(data.token);
                            },
                        });
                    } else if (result.isDenied) {
                        
                    }
                });
        }
    }
    
    function last(){
        
        Swal.fire({
            title: 'Confirma as informações preenchidas?',
            showDenyButton: true,
            showCancelButton: false,
            confirmButtonText: 'Sim, estão corretas.',
            denyButtonText: `Não, vou conferir.`,
            }).then((result) => {
                if (result.isConfirmed) {
                    var myForm = document.getElementById('formCheckList');
                    var dados = new FormData(myForm);
                    $.ajax({
                        url: '<?php echo base_url('steps'); ?>',
                        method: 'post',
                        data: dados,
                        processData: false,
                        contentType: false,
                        dataType: 'json',
                        beforeSend: function(){
                            //$("#steppers").css("display", "none");
                            //$("#helper-part").css("display", "block");
                        },
                        error: function(xhr, status, error) {
                            console.log(error);
                            console.log(status);
                            console.log(xhr);
                        },
                        success: function(data) {
                            console.log(data);
                            if(data.error == 1){
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops...',
                                    text: data.msg,
                                });
                            }else{
                                Swal.fire({
                                    icon: 'success',    
                                    title: 'Concluído.',
                                    text: data.msg,
                                    showDenyButton: false,
                                    showCancelButton: false,
                                    confirmButtonText: 'Ok',
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        location.reload();
                                    }
                                })
                            }
                        },
                    });
                }
            });
    }
    
</script>

<script>
    function saveChklst(id){
        const dados = [];
        
        data = new FormData();
        data.append('token', $("#token").val());
        
        if(id == "documentos"){
        <?php $aux=0; foreach($documentos as $doc){?>
            dados[<?php echo $aux; ?>] = 
                    [<?php echo $doc['item_id']; ?>, $("#"+<?php echo $doc['item_id']?>+"-obs").val()]
                ;
        <?php $aux++; }?>
        }else if(id == "cabineinterna"){
        <?php $aux=0; foreach($cabineinterna as $doc){?>
            dados[<?php echo $aux; ?>] = 
                    [<?php echo $doc['item_id']; ?>, $("#"+<?php echo $doc['item_id']?>+"-obs").val()]
                ;
        <?php $aux++; }?>
        }else if(id == "sistemaeletrico"){
        <?php $aux=0; foreach($sistemaeletrico as $doc){?>
            dados[<?php echo $aux; ?>] = 
                    [<?php echo $doc['item_id']; ?>, $("#"+<?php echo $doc['item_id']?>+"-obs").val()]
                ;
        <?php $aux++; }?>
        }else if(id == "cabineexterna"){
        <?php $aux=0; foreach($cabineexterna as $doc){?>
            dados[<?php echo $aux; ?>] = 
                    [<?php echo $doc['item_id']; ?>, $("#"+<?php echo $doc['item_id']?>+"-obs").val()]
                ;
        <?php $aux++; }?>
        }else if(id == "cabineinterna"){
        <?php $aux=0; foreach($cabineinterna as $doc){?>
            dados[<?php echo $aux; ?>] = 
                    [<?php echo $doc['item_id']; ?>, $("#"+<?php echo $doc['item_id']?>+"-obs").val()]
                ;
        <?php $aux++; }?>
        }else if(id == "cabinesuplementar"){
        <?php $aux=0; foreach($cabinesuplementar as $doc){?>
            dados[<?php echo $aux; ?>] = 
                    [<?php echo $doc['item_id']; ?>, $("#"+<?php echo $doc['item_id']?>+"-obs").val()]
                ;
        <?php $aux++; }?>
        }else if(id == "munck"){
        <?php $aux=0; foreach($munck as $doc){?>
            dados[<?php echo $aux; ?>] = 
                    [<?php echo $doc['item_id']; ?>, $("#"+<?php echo $doc['item_id']?>+"-obs").val()]
                ;
        <?php $aux++; }?>
        }else if(id == "carroceria"){
                <?php $aux=0; foreach($carroceria as $doc){?>
            dados[<?php echo $aux; ?>] = 
                    [<?php echo $doc['item_id']; ?>, $("#"+<?php echo $doc['item_id']?>+"-obs").val()]
                ;
        <?php $aux++; }?>
        }else if(id == "pneus"){
        <?php $aux=0; foreach($pneus as $doc){?>
            dados[<?php echo $aux; ?>] = 
                    [<?php echo $doc['item_id']; ?>, $("#"+<?php echo $doc['item_id']?>+"-obs").val()]
                ;
        <?php $aux++; }?>
        }
        
        data.append('dados', JSON.stringify(dados));
        
        $.ajax({
            url: '<?php echo base_url('steppers'); ?>',
            method: 'post',
            data: data,
            processData: false,
            contentType: false,
            dataType: 'json',
            beforeSend: function(){
                
            },
            error: function(xhr, status, error) {
                console.log(error);
                console.log(status);
                console.log(xhr);
            },
            success: function(data) {
                if(data == true){
                    stepper.next();
                }else{
                    console.log(data);
                }
            },
        });
    }
</script>
<script>
    function finish(){
        Swal.fire({
            title: 'CheckList finalizado!',
            icon: 'success',
            showCancelButton: false,
            confirmButtonText: 'Ok!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.replace("<?php echo base_url('listChck'); ?>");
            }
        });
    }
</script>