<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Ticketpesagem extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('frotamodel');
        $this->load->model('ticketpesagemmodel');
        $this->load->model('configuracaomodel');
    }

    public function itens()
    {
        $this->acessorestrito("VALE REFEIÇÃO");

        $pag = '11.1';
        $titulo = 'LISTAGEM DE TICKET DE PESAGEM';
        $raiz = '#';
        $local = 'Ticket de Pesagem';
        $funcao = 'Itens';

        $frota = $this->frotamodel->getAll();
        $ticketpesagem = $this->ticketpesagemmodel->getAll();
        $motoristas = $this->ticketpesagemmodel->getMotoristas();
        $clientes = $this->ticketpesagemmodel->getClientes();
        $produtos = $this->ticketpesagemmodel->getProdutos();
        $configuracoes = $this->configuracaomodel->getConfiguracao();


        $arg = 0;
        foreach ($frota as $veiculo) {
            $modelo = $this->frotamodel->getModeloByIdRowArray($veiculo['frota_modelo_id']);
            $marca = $this->frotamodel->getMarcaByIdRowArray($modelo['frota_modelo_marca_id']);
            //$linhas = $this->frotamodel->getLinhaByIdRowArray($veiculo['frota_linha_id']);
            $tiposgabine = $this->frotamodel->getTipoGabineByIdRowArray($veiculo['frota_tipogabine_id']);
            $tiposmunck = $this->frotamodel->getTipoMunckByIdRowArray($veiculo['frota_tipomunck_id']);
            //$status = $this->frotamodel->getStatusById($veiculo['frota_status_id']);
            $nome = $veiculo['frota_placa'] . ' - ' . $marca['frota_marca_nome'] . $modelo['frota_modelo_nome'] . ' - ' . "(Cabine: " . $tiposgabine['frota_tipogabine_nome'] . " ; " . $tiposmunck['frota_tipomunck_nome'] . ")";
            $frota[$arg] = [
                'nome'   => $nome,
                'placa'     => $veiculo['frota_placa'],
                'frota'     => $veiculo['frota_codigo'],
                'id'        => $veiculo['frota_id'],
                'ativo_id'  => $veiculo['frota_ativo_id'],
            ];
            $arg++;
        }

        foreach ($ticketpesagem as $key => $value) {
            foreach ($frota as $veiculo) {
                if ($value['tk_veiculo_id'] == $veiculo['id']) {
                    $ticketpesagem[$key]['veiculo'] = $veiculo;
                } else {
                    //$abastecimento[$key]['veiculo'] = [];
                }
            }
        }


        $data['itens'] = $ticketpesagem;
        $data['motoristas'] = $motoristas;
        $data['clientes'] = $clientes;
        $data['veiculos'] = $frota;
        $data['produtos'] = $produtos;
        $data['config'] = $configuracoes;

        $this->header($pag, $titulo, $raiz, $local, $funcao);
        $this->load->view('ticketpesagem/listagem', $data);
        $this->footer();
    }

    public function novoitem()
    {
        $dados = array(
            'tk_data'             => $this->input->post('tk_data'),
            'tk_motorista_id'         => $this->input->post('tk_motorista_id'),
            'tk_carreta_id'       => $this->input->post('tk_carreta_id'),
            'tk_veiculo_id'       => $this->input->post('tk_veiculo_id'),
            'tk_item_id'      => $this->input->post('tk_item_id'),
            'tk_cliente_cpfcnpj'          => $this->input->post('tk_cliente_cpfcnpj'),
            'tk_transportadora'               => $this->input->post('tk_transportadora'),
            'tk_tipo_movimento'           => $this->input->post('tk_tipo_movimento'),
            'tk_deposito'             => $this->input->post('tk_deposito'),
            'tk_tipo_veiculo'             => $this->input->post('tk_tipo_veiculo'),
            'tk_pesagem_inicial'          => $this->input->post('tk_pesagem_inicial'),
            'tk_pesagem_final'            => $this->input->post('tk_pesagem_final'),
            'tk_peso_liquido'             => $this->input->post('tk_peso_liquido'),
            'tk_quantidade_carregar'          => $this->input->post('tk_quantidade_carregar'),
            'tk_pre_data'           => $this->input->post('tk_pre_data'),
            'tk_pre_operador'       => $this->input->post('tk_pre_operador'),
            'tk_pre_motorista'      => $this->input->post('tk_pre_motorista'),
            'tk_pi_data'            => $this->input->post('tk_pi_data'),
            'tk_pi_balanca'         => $this->input->post('tk_pi_balanca'),
            'tk_pi_peso'            => $this->input->post('tk_pi_peso'),
            'tk_pi_operador'        => $this->input->post('tk_pi_operador'),
            'tk_pi_motorista'       => $this->input->post('tk_pi_motorista'),
            'tk_pf_data'            => $this->input->post('tk_pf_data'),
            'tk_pf_balanca'         => $this->input->post('tk_pf_balanca'),
            'tk_pf_peso'            => $this->input->post('tk_pf_peso'),
            'tk_pf_operador'        => $this->input->post('tk_pf_operador'),
            'tk_pf_motorista'       => $this->input->post('tk_pf_motorista'),
            'tk_ticket_pesagem'     => $this->input->post('tk_ticket_pesagem'),
            'tk_unidade'            => $this->input->post('tk_unidade'),
            'tk_observacao'         => $this->input->post('tk_observacao'),
            'tk_numero_nota'        => $this->input->post('tk_numero_nota'),
            'tk_diferenca_origem'        => $this->input->post('tk_diferenca_origem'),
        );

        if ($this->input->post('tk_id') != null) {
            $id = $this->input->post('tk_id');

            $file_name = $this->upload_image('5-doc');
            if (isset($file_name) && $file_name != null) {
                $dados['tk_anexo'] = $file_name;
            }

            $file_name = $this->upload_image('6-doc');
            if (isset($file_name) && $file_name != null) {
                $dados['tk_anexo2'] = $file_name;
            }

            $this->ticketpesagemmodel->updateItem($id, $dados);
            redirect(base_url('ticketpesagem'));
        } else {

            $file_name = $this->upload_image('5-doc');
            if (isset($file_name) && $file_name != null) {
                $dados['tk_anexo'] = $file_name;
            }

            $file_name = $this->upload_image('6-doc');
            if (isset($file_name) && $file_name != null) {
                $dados['tk_anexo2'] = $file_name;
            }

            $last_item = $this->ticketpesagemmodel->get_last_item();
            $tk_solicitacao_id = $last_item[0]['tk_solicitacao_id'];
            $aux_num = str_replace('Tk', '', $tk_solicitacao_id);

            if (isset($tk_solicitacao_id)) {
                $dados['tk_solicitacao_id'] = $this->numZero((int)$aux_num + 1);
            } else {
                $dados['tk_solicitacao_id'] = $this->numZero(1);
            }

            $this->ticketpesagemmodel->addItem($dados);
            redirect(base_url('ticketpesagem'));
        }
    }

    function deleteAnexo()
    {
       
        $id = $this->input->post('id');
        $id_index = $this->input->post('index');
        $ticket = $this->ticketpesagemmodel->getById($id);


        var_dump($id_index);

        if ($id_index == 1 && $ticket['tk_anexo'] != null) {
            unlink('./uploads/' . $ticket['tk_anexo']);
            $dados = array( 'tk_anexo' => null );
            $this->ticketpesagemmodel->deleteAnexo($id, $dados);

        }
        if ($id_index == 2 && $ticket['tk_anexo2'] != null) {
            unlink('./uploads/' . $ticket['tk_anexo2']);
            $dados = array( 'tk_anexo2' => null );
            $this->ticketpesagemmodel->deleteAnexo($id, $dados);
        }
       
        //redirect(base_url('ticketpesagem'));
    }

    public function upload_image($file)
    {
        $this->load->library('upload');

        // Define as configurações para o upload
        $config['upload_path'] = './uploads/';
        $config['allowed_types'] = 'jpg|jpeg|png';  // Apenas formatos compatíveis com a conversão
        $config['max_size'] = 2048;  // Tamanho máximo em KB

        // Inicializa as configurações
        $this->upload->initialize($config);

        if (!$this->upload->do_upload($file)) {
            // Em caso de erro, exibe a mensagem
            $error = array('error' => $this->upload->display_errors());
            print_r($error);
        } else {
            // Se o upload foi bem-sucedido
            $upload_data = $this->upload->data();  // Dados do arquivo
            $uploaded_file_path = $upload_data['full_path'];  // Caminho completo do arquivo
            $file_name = time() . '_' . $upload_data['raw_name'] . '.webp';  // Nome do arquivo
            $converted_file_path = './uploads/' . $file_name;  // Caminho do arquivo WebP

            // Convertendo a imagem para WebP
            if ($this->convert_to_webp($uploaded_file_path, $converted_file_path)) {
                // Caso a conversão seja bem-sucedida, carrega a view de sucesso
                $data = array(
                    'upload_data' => $upload_data,
                    'webp_path' => $converted_file_path
                );
                return $file_name;
            } else {
                // Caso a conversão falhe
                $error = array('error' => 'Falha ao converter a imagem para WebP.');
                print_r($error);
                return false;
            }
        }
    }

    private function convert_to_webp($source, $destination)
    {
        // Identifica o tipo da imagem
        $info = getimagesize($source);
        $mime = $info['mime'];

        switch ($mime) {
            case 'image/jpeg':
                $image = imagecreatefromjpeg($source);
                break;
            case 'image/png':
                $image = imagecreatefrompng($source);
                break;
            default:
                return false;  // Tipo de arquivo não suportado
        }

        // Converte e salva a imagem no formato WebP
        if (imagewebp($image, $destination, 80)) {  // Qualidade 80 (pode ser ajustada)
            imagedestroy($image);  // Libera a memória
            return true;
        } else {
            return false;
        }
    }

    function numZero($valor)
    {
        if ($valor < 10) {
            $valor = "Tk000000" . $valor;
        } else if ($valor < 100) {
            $valor = "Tk00000" . $valor;
        } else if ($valor < 1000) {
            $valor = "Tk0000" . $valor;
        } else if ($valor < 10000) {
            $valor = "Tk000" . $valor;
        } else if ($valor < 100000) {
            $valor = "Tk00" . $valor;
        } else if ($valor < 1000000) {
            $valor = "Tk0" . $valor;
        }
        return $valor;
    }

    function deletar()
    {
        $this->ticketpesagemmodel->deletarItem($this->input->post('tk_id'));
        redirect(base_url('ticketpesagem'));
    }
}
