<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Oleo extends MY_Controller {
    
    public function __construct(){
        parent::__construct();
        $this->load->database();
        $this->load->model('oleomodel');
    }

    /**=======================================================================================**
    /||                                                                     ||
    /**=======================================================================================**/
    
    public function index(){
            $pag = '8.1';
            $titulo = 'TROCA DE OLEO';
            $raiz = '#';
            $local = 'Oleo';
            $funcao = 'Listagem';
            
            $data['frota'] = $this->oleomodel->getFrotaListAtiva();
            
            $this->header($pag, $titulo, $raiz, $local, $funcao);
            $this->load->view('oleo/lista', $data);
            $this->footer();
    }
    
    public function updateChange(){
        $aux = explode(",", $_POST['dados']);
        $newArray = array(
            'troca_oleo_frota_id'   =>$aux[0], 
            'troca_oleo_data'       =>date('Y-m-d', strtotime($aux[3])), 
            'troca_oleo_km'         =>$aux[1], 
            'troca_oleo_proximo'    =>$aux[2],
            );
        $aux = $this->oleomodel->updateTrocas($newArray);
        
        echo json_encode($aux);
    }
    
    public function uploadFile(){
        $config['upload_path']          = 'imagens/trocaOleo/';
        $config['allowed_types']        = '*';
        $config['file_name']            = $_POST['id'];

        $this->load->library('upload', $config);
        
        if(!$this->upload->do_upload('file')){
            $error = array('error' => $this->upload->display_errors());
            $this->index();
        } else {
            $data = array('upload_data' => $this->upload->data());
            
            $this->index();
        }
    }
    
    public function openFile($id = null){
        if($id == null){
            $this->index();
        }else{
            $path = "imagens/trocaOleo/";
            $files = glob($path . $id . ".*", GLOB_ERR);
            redirect(base_url($files));
        }
    }
    
}
