<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Abastecimento extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('abastecimentomodel');
        $this->load->model('frotamodel');
    }

    public function itens()
    {
        $this->acessorestrito("VALE REFEIÇÃO");

        $pag = '10.1';
        $titulo = 'LISTA DE ABASTECIMENTO';
        $raiz = '#';
        $local = 'Abastecimento';
        $funcao = 'Itens';

        $abastecimento = $this->abastecimentomodel->getAll();
        $motoristas = $this->abastecimentomodel->getMotoristas();
        $fornecedores = $this->abastecimentomodel->getFornecedores();
        $frota = $this->frotamodel->getAll();

        $arg = 0;
        foreach ($frota as $veiculo) {
            $modelo = $this->frotamodel->getModeloByIdRowArray($veiculo['frota_modelo_id']);
            $marca = $this->frotamodel->getMarcaByIdRowArray($modelo['frota_modelo_marca_id']);
            //$linhas = $this->frotamodel->getLinhaByIdRowArray($veiculo['frota_linha_id']);
            $tiposgabine = $this->frotamodel->getTipoGabineByIdRowArray($veiculo['frota_tipogabine_id']);
            $tiposmunck = $this->frotamodel->getTipoMunckByIdRowArray($veiculo['frota_tipomunck_id']);
            //$status = $this->frotamodel->getStatusById($veiculo['frota_status_id']);
            $nome = $veiculo['frota_placa'] . ' - ' . $marca['frota_marca_nome'] . $modelo['frota_modelo_nome'] . ' - ' . "(Cabine: " . $tiposgabine['frota_tipogabine_nome'] . " ; " . $tiposmunck['frota_tipomunck_nome'] . ")";
            $frota[$arg] = [
                'nome'   => $nome,
                'placa'     => $veiculo['frota_placa'],
                'frota'     => $veiculo['frota_codigo'],
                'id'        => $veiculo['frota_id'],
                'ativo_id'  => $veiculo['frota_ativo_id'],
            ];
            $arg++;
        }

        foreach ($abastecimento as $key => $value) {
            foreach ($frota as $veiculo) {
                if ($value['abst_veiculo_id'] == $veiculo['id']) {
                    $abastecimento[$key]['veiculo'] = $veiculo;
                } else {
                    //$abastecimento[$key]['veiculo'] = [];
                }
            }
        }

        $data['itens'] = $abastecimento;
        $data['motoristas'] = $motoristas;
        $data['fornecedores'] = $fornecedores;
        $data['veiculos'] = $frota;

        $this->header($pag, $titulo, $raiz, $local, $funcao);
        $this->load->view('abastecimento/listagem', $data);
        $this->footer();
    }

    public function novoitem()
    {
        $dados = array(
            'abst_data_hora'      => $this->input->post('abst_data_hora'),
            'abst_fornecedor_cnpj'    => $this->input->post('abst_fornecedor_cnpj'),
            'abst_veiculo_id'   => $this->input->post('abst_veiculo_id'),
            'abst_motorista_id'      => $this->input->post('abst_motorista_id'),
            'abst_quantidade_litros'           => $this->input->post('abst_quantidade_litros'),
            'abst_combustivel'       => $this->input->post('abst_combustivel'),
            'abst_valor'            => $this->input->post('abst_valor'),
            'abst_quitada' => "Não",
            'abst_protocolo'        => $this->input->post('abst_protocolo'),
        );

        if ($this->input->post('abst_id') != null) {
            $id = $this->input->post('abst_id');

            $file_name = $this->upload_image();
            if (isset($file_name) && $file_name != null) {
                $dados['abst_anexo_abastecimento'] = $file_name;
            }

            $this->abastecimentomodel->updateItem($id, $dados);

            redirect(base_url('abastecimento'));
        } else {

            $file_name = $this->upload_image();
            if (isset($file_name) && $file_name != null) {
                $dados['abst_anexo_abastecimento'] = $file_name;
            }

            $last_item = $this->abastecimentomodel->get_last_item();
            $abst_solicitacao_abastecimento_id = $last_item[0]['abst_solicitacao_abastecimento_id'];
            $aux_num = str_replace('AB', '', $abst_solicitacao_abastecimento_id );

            if (isset($abst_solicitacao_abastecimento_id )) {
                $dados['abst_solicitacao_abastecimento_id'] = $this->numZero( (int)$aux_num + 1 );
            } else {
                $dados['abst_solicitacao_abastecimento_id'] = $this->numZero(1);
            }


            $this->abastecimentomodel->addItem($dados);
            $this->lancatitulo($dados);

            redirect(base_url('abastecimento'));
        }
    }

    function deletar(){
        $this->abastecimentomodel->deletarItem($this->input->post('abst_id'));
        redirect(base_url('abastecimento'));
    }

    public function lancatitulo($data)
    {

        $this->load->model('estoquemodel');
        $this->load->model('financeiromodel');

        $especie = "68";
        $vencimento = $data['abst_data_hora'];
        $recorrente = "0";
        $repeticao = "0";
        $numserInit = $data['abst_solicitacao_abastecimento_id'];
        $forneclin = 'F|' . $data['abst_fornecedor_cnpj'];
        $valor = $data['abst_valor'];
        $obs = "Nota de abastecimento";
        $numos = $data['abst_solicitacao_abastecimento_id'];

        $aux = $this->estoquemodel->getTipoUnico($especie);

        $dt = $vencimento;
        $newDt = [];
        if ($recorrente == 1 || $recorrente == "1") {
            $vezes = intval($repeticao);
            for ($i = 0; $i < $vezes; $i++) {
                $newDt[$i] = date('Y-m-d', strtotime($dt . ' +' . $i . ' month'));
            }
        } else {
            $vezes = 1;
            $newDt[0] = $dt;
        }

        $x = 1;
        for ($i = 0; $i < $vezes; $i++) {
            if ($i == 0) {
                $newDt[$i] = $vencimento;
            }
            if ($vezes > 1) {
                $numser = 'RC- ' . $this->refatorarString($numserInit) . ' ' . $x . '/' . $vezes;
                $x++;
            } else {
                $numser = $this->refatorarString($numserInit);
            }

            $data = array(
                'titulos_vencimento'    => $newDt[$i],
                'titulos_numeroserie'   => $numser,
                'titulos_tipo'          => $especie,
                'titulos_forneclin'     => $forneclin,
                'titulos_atraso'        => "0",
                'titulos_valor'         => $this->reformatavalor($valor),
                'titulos_juros'         => 0.00,
                'titulos_multa'         => 0.00,
                'titulos_desconto'      => 0.00,
                'titulos_valorpago'     => "0.0",
                'titulos_formapag'      => "",
                'titulos_frota'         => null,
                'titulos_rateio'        => null,
                'titulos_observacao'    => $this->refatorarString($obs),
                'titulos_pagobs'        => "",
                'titulos_IO'            => $aux['tm_tipo'],
                'titulos_baixa'         => 0,
                'titulos_completo'      => 1,
                'titulos_numos'         => $numos,
            );

            $this->financeiromodel->putTitulos($data);
        }
    }

    function deleteAnexo()
    {
       
        $id = $this->input->post('id');
        $id_index = $this->input->post('index');
        $ticket = $this->abastecimentomodel->getById($id);


        var_dump($id_index);

        if ($id_index == 1 && $ticket['abst_anexo_abastecimento'] != null) {
            $dados = array( 'abst_anexo_abastecimento' => null );
            $this->abastecimentomodel->deleteAnexo($id, $dados);
            unlink('./uploads/' . $ticket['abst_anexo_abastecimento']);

        }
        if ($id_index == 2 && $ticket['abst_anexo2'] != null) {
            unlink('./uploads/' . $ticket['abst_anexo2']);
            $dados = array( 'abst_anexo2' => null );
            $this->abastecimentomodel->deleteAnexo($id, $dados);

        }
       
        //redirect(base_url('ticketpesagem'));
    }

    public function upload_image()
    {
        $this->load->library('upload');

        // Define as configurações para o upload
        $config['upload_path'] = './uploads/';
        $config['allowed_types'] = 'jpg|jpeg|png';  // Apenas formatos compatíveis com a conversão
        $config['max_size'] = 2048;  // Tamanho máximo em KB

        // Inicializa as configurações
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('5-doc')) {
            // Em caso de erro, exibe a mensagem
            $error = array('error' => $this->upload->display_errors());
            print_r($error);
        } else {
            // Se o upload foi bem-sucedido
            $upload_data = $this->upload->data();  // Dados do arquivo
            $uploaded_file_path = $upload_data['full_path'];  // Caminho completo do arquivo
            $file_name = time() . '_' . $upload_data['raw_name'] . '.webp';  // Nome do arquivo
            $converted_file_path = './uploads/' . $file_name;  // Caminho do arquivo WebP

            // Convertendo a imagem para WebP
            if ($this->convert_to_webp($uploaded_file_path, $converted_file_path)) {
                // Caso a conversão seja bem-sucedida, carrega a view de sucesso
                $data = array(
                    'upload_data' => $upload_data,
                    'webp_path' => $converted_file_path
                );
                return $file_name;
            } else {
                // Caso a conversão falhe
                $error = array('error' => 'Falha ao converter a imagem para WebP.');
                print_r($error);
                return false;
            }
        }
    }

    private function convert_to_webp($source, $destination)
    {
        // Identifica o tipo da imagem
        $info = getimagesize($source);
        $mime = $info['mime'];

        switch ($mime) {
            case 'image/jpeg':
                $image = imagecreatefromjpeg($source);
                break;
            case 'image/png':
                $image = imagecreatefrompng($source);
                break;
            default:
                return false;  // Tipo de arquivo não suportado
        }

        // Converte e salva a imagem no formato WebP
        if (imagewebp($image, $destination, 80)) {  // Qualidade 80 (pode ser ajustada)
            imagedestroy($image);  // Libera a memória
            return true;
        } else {
            return false;
        }
    }

    private function reformatavalor($valor)
    {
        $valor = str_replace(".", "", $valor);
        $valor = str_replace(",", ".", $valor);
        return $valor;
    }

    function numZero($valor)
    {
        if ($valor < 10) {
            $valor = "AB000000" . $valor;
        } else if ($valor < 100) {
            $valor = "AB00000" . $valor;
        } else if ($valor < 1000) {
            $valor = "AB0000" . $valor;
        } else if ($valor < 10000) {
            $valor = "AB000" . $valor;
        } else if ($valor < 100000) {
            $valor = "AB00" . $valor;
        } else if ($valor < 1000000) {
            $valor = "AB0" . $valor;
        }
        return $valor;
    }
}
