<style>
    .tableFixHead          { overflow-y: auto; height: 600px; }
    .tableFixHead thead th { position: sticky; top: 0; }
    
    /* Just common table stuff. Really. */
    table  { border-collapse: collapse; width: 100%; }
    th, td { padding: 8px 16px; }
    th     { background:#eee; }
</style>

<br>
<section id="main-content">
    
    <section class="wrapper">
        
        <div class="row">
            <div class="col-md-6">
                <h3>Motoristas > Listagem</h3>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="<?php echo base_url('motoristas/cadastro'); ?>" class="btn btn-success" style='margin-top: 20px; border: 1px solid #4ECDC4; background-color: #4ECDC4; color: white'>Novo Motorista</a>
            </div>
        </div>
        
        <hr style="height: 1px; background-color: #ccc; border: none;">
        
        <div class="row" style="margin-left: 0px; margin-right: 0px">
            <div class="col-md-12" style="background-color: white;">
               <br>
               
                <div class="tableFixHead">
                    <table id="myTableMotorista" class="table table-hover table-bordered">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>CPF</th>
                                <th>Telefone</th>
                                <th>Cidade</th>
                                <th style="width: 180px">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($motoristas as $motorista){ 
                                if($motorista['motorista_ativo_id'] != 2){
                            ?>
                            <tr>
                                <td><?php echo $motorista['motorista_nome'] ?></td>
                                <td><?php echo $motorista['motorista_cpf'] ?></td>
                                <td><?php echo $motorista['motorista_tel'] ?></td>
                                <td><?php echo $motorista['motorista_cidade'] . ' - ' . $motorista['motorista_estado'] ?></td>
                                <td>
                                    <a style="font-size: 12px" data-toggle="modal" data-target="#modalMotorista" data-usuario="" class="btn btn-primary btn-modal-toggle"><i class="fas fa-eye"></i></a>
                                    <a style="font-size: 12px" href="" class="btn btn-primary" ><i class="fas fa-pencil-alt"></i></a>
                                    <a data-toggle="modal" data-target="#modalExcluir" style="font-size: 12px" class="btn btn-danger" onclick="setaExcluir(<?php echo $motorista['motorista_id'] ?>)"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                            <?php }
                                }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Nome</th>
                                <th>CPF</th>
                                <th>Telefone</th>
                                <th>Cidade</th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                
                <br>
            </div>
        </div>
        <br><br>
    </section>
</section>

<!-- modalExcluir -->
<div class="modal fade" id="modalExcluir" tabindex="-1" role="dialog" aria-labelledby="modalExcluirTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Mensagem do Sistema</h5>
            </div>
            <div class="modal-body">
                <h4>Deseja realmente excluir o motorista?</h4>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" style="border: 1px solid #4ECDC4; background-color: #4ECDC4; color: white; float: left" onclick="senha()">&nbsp&nbspSim&nbsp&nbsp</button>
                <button class="btn btn-danger" data-dismiss="modal">&nbsp&nbspNão&nbsp&nbsp</button>
                <br><br>
                <div class="row" id="formsenha" style="display: none">
                    <div class="col-md-12 text-center">
                        <form action="<?php echo base_url('motoristas/deleteMotorista') ?>" method="post">
                            <input type="hidden" name="idmotorista" id="idmotorista">
                            <label style="font-size: 16px">Confirme a senha</label><br>
                            <input class="form-control" type="password" name="senha" id="senha" placeholder="Digite a Senha" required style="width: 50%; margin-left: 25%"><br>
                            <button type="submit" class="btn btn-primary" style="border: 1px solid #4ECDC4; background-color: #4ECDC4; color: white">&nbsp&nbspConfirmar&nbsp&nbsp</button>
                        </form>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
</div>

<!-- ModalUsuario -->
<div class="modal fade" id="modalUsuario" tabindex="-1" role="dialog" aria-labelledby="modalUsuario" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            
            <div class="modal-header">
                <div class="row">
                    <div class="col-md-11">
                        <h4 class="modal-title" id="text-nome" name="text-nome">Nome Completo</h4>
                    </div>
                    <div class="col-md-1">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                </div>
            </div>
            
            <div class="modal-body" style="background-color: #eaeaea; padding-bottom: 0px">
                <ul class="nav nav-tabs" id="myTab" role="tablist" style="background-color: #eaeaea">
                    <li class="nav-item">
                        <a class="nav-link" style="background-color: white; cursor: pointer" id="aDados" onclick="change(1)">Dados</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" style="cursor: pointer" id="aDias" onclick="change(2)">Dias</a>
                    </li>
                </ul>
                <div class="row" id="divDados" style="display: block;">
                    <div class="col-md-12" style="background-color: white">
                        <br>
                        
                        <div class="row form-group">
                            <div class="col-md-12">
                                <label>Função: </label>
                                <br>
                                <label style="color: black; font-size: 16px" id="text-funcao" name="text-funcao">Função</label>
                            </div>
                        </div>
                        
                        <div class="row form-group">
                            <div class="col-md-6">
                                <label>CPF: </label>
                                <br>
                                <label style="color: black; font-size: 16px" id="text-cpf">XXX.XXX.XXX-XX</label>
                            </div>
                            <div class="col-md-6">
                                <label>Telefone: </label>
                                <br>
                                <label style="color: black; font-size: 16px" id="text-telefone">(XX) XXXX-XXXX</label>
                            </div>
                        </div>
                        
                        <div class="row form-group">
                            <div class="col-md-12">
                                <label>Endereco: </label>
                                <br>
                                <label style="color: black; font-size: 16px" id="text-endereco">Rua X, nº X, X - X</label>
                            </div>    
                        </div>

                        <br>
                    </div>
                </div>
                <div class="row" id="divDias" style="display: none">
                    <div class="col-md-12" style="background-color: white">
                        <br>

                        <div class="row">
                            <div class="col-md-12">
                                <label>Dias e Horário de Trabalho:</label>
                                <br><br>
                                <label style="color: black; font-size: 16px" id="text-trabalho">Dia: XX:XX às XX:XX</label>
                            </div>
                        </div>

                        <br>
                    </div>
                </div>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<script>
    function setaExcluir(id){
        document.getElementById('idmotorista').value = id;
    }
    function senha(){
        document.getElementById('formsenha').style.display = "block";
    }
</script>

<script>
    function change(value){
        if(value == 1){
            document.getElementById('aDados').style = "background-color: white; cursor: pointer";
            document.getElementById('aDias').style = "background-color: #eaeaea; cursor: pointer";
            document.getElementById('divDados').style.display = "block";
            document.getElementById('divDias').style.display = "none";
        }else{
            document.getElementById('aDias').style = "background-color: white; cursor: pointer";
            document.getElementById('aDados').style = "background-color: #eaeaea; cursor: pointer";
            document.getElementById('divDias').style.display = "block";
            document.getElementById('divDados').style.display = "none";
        }
    }
</script>

<script>
    $(document).ready(function(){
        
        
        $('#myTableMotorista').DataTable( {
            "order": [[ 0, "asc" ]],
            "language": {
                "lengthMenu": "Mostrando _MENU_ registros por página",
                "zeroRecords": "Nada encontrado- refaça sua busca",
                "info": "Mostrando _PAGE_ de _PAGES_",
                "infoEmpty": "Sem registros disponíves",
                "infoFiltered": "(filtrado _MAX_ dos registros totais)",
                "sSearch":       "Procurar:",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Próximo",
                }
            },
            "columns": [
                {"Nome": "first", "orderable": true},
                {"CPF": "second", "orderable": true},
                {"Telefone": "third", "orderable": true},
                {"Cidade": "fourth", "orderable": true},
                {"Ação": "fifth", "orderable": false},
            ],
            initComplete: function () {
                this.api().columns([0]).every( function () {
                    var column = this;
                    var select = $('<select class="js-example-basic-multiple" style="width: 100%"><option value="">Todos</option></select>')
                        .appendTo( $(column.footer()).empty() )
                        .on( 'change', function () {
                            var val = $.fn.dataTable.util.escapeRegex(
                                $(this).val()
                            );
                             column
                                .search( val ? '^'+val+'$' : '', true, false )
                                .draw();
                                } );
       
                    column.data().unique().sort().each( function ( d, j ) {
                        select.append( '<option value="'+d+'">'+d+'</option>' )
                    } );
                } );
                this.api().columns([1]).every( function () {
                    var column = this;
                    var select = $('<select class="js-example-basic-multiple" style="width: 100%"><option value="">Todos</option></select>')
                        .appendTo( $(column.footer()).empty() )
                        .on( 'change', function () {
                            var val = $.fn.dataTable.util.escapeRegex(
                                $(this).val()
                            );
                             column
                                .search( val ? '^'+val+'$' : '', true, false )
                                .draw();
                                } );
       
                    column.data().unique().sort().each( function ( d, j ) {
                        select.append( '<option value="'+d+'">'+d+'</option>' )
                    } );
                } );
                this.api().columns([2]).every( function () {
                    var column = this;
                    var select = $('<select class="js-example-basic-multiple" style="width: 100%"><option value="">Todas</option></select>')
                        .appendTo( $(column.footer()).empty() )
                        .on( 'change', function () {
                            var val = $.fn.dataTable.util.escapeRegex(
                                $(this).val()
                            );
                             column
                                .search( val ? '^'+val+'$' : '', true, false )
                                .draw();
                                } );
       
                    column.data().unique().sort().each( function ( d, j ) {
                        select.append( '<option value="'+d+'">'+d+'</option>' )
                    } );
                } );
                this.api().columns([3]).every( function () {
                    var column = this;
                    var select = $('<select class="js-example-basic-multiple" style="width: 100%"><option value="">Todos</option></select>')
                        .appendTo( $(column.footer()).empty() )
                        .on( 'change', function () {
                            var val = $.fn.dataTable.util.escapeRegex(
                                $(this).val()
                            );
                             column
                                .search( val ? '^'+val+'$' : '', true, false )
                                .draw();
                                } );
       
                    column.data().unique().sort().each( function ( d, j ) {
                        select.append( '<option value="'+d+'">'+d+'</option>' )
                    } );
                } );
            }
        } );
    });
</script>