<style>
    .tableFixHead          { overflow-y: auto; height: 450px; }
    .tableFixHead thead th { position: sticky; top: 0; }
    
    /* Just common table stuff. Really. */
    table  { border-collapse: collapse; width: 100%; }
    th, td { padding: 8px 16px; }
    th     { background:#eee; }
</style>

<br>
<section id="main-content">
    
    <section class="wrapper">
        
        <div class="row">
            <div class="col-md-6">
                <h3>Cadastros > Fornecedores</h3>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="<?php echo base_url('cadastros/novoFornecedor') ?>" class="btn btn-success" style='margin-top: 20px; border: 1px solid #4ECDC4; background-color: #4ECDC4; color: white'>Novo Fornecedor</a>
            </div>
        </div>
        
        <hr style="height: 1px; background-color: #ccc; border: none;">
        
        <div class="row" style="margin-left: 0px; margin-right: 0px">
            <div class="col-md-12" style="background-color: white;">
                <br>
                
                <?php if($erro != null){ ?>
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="text-danger">Erro: A senha informada estava incorreta, por favor tente novamente!</h3>
                    </div>
                </div>
                <br>
                <?php } ?>
                
                <div class="tableFixHead">
				    <table id="myTableForn" class="table table-hover table-bordered">
				        <thead>
				            <tr>
				                <th>Nome</th>
				                <th>CPNJ</th>
				                <th style="width: 180px">Ação</th>
				            </tr>
				        </thead>
				        <tbody>
				            <?php foreach($fornecedores as $f){ 
				                if($this->session->userdata('c_a') != 1 && $f['fornecedor_ativo_id'] != 2){
				            ?>
				            <tr>
				                <td><?php echo mb_strtoupper($f['fornecedor_nome']) ?></td>
				                <td>
				                    <?php 
				                    $cnpj = substr($f['fornecedor_cnpj'], 0, 2).".".substr($f['fornecedor_cnpj'], 2, 3).".".substr($f['fornecedor_cnpj'], 5, 3)."/".substr($f['fornecedor_cnpj'], 8, 4)."-".substr($f['fornecedor_cnpj'], 12, 2);
				                    echo $cnpj;
				                    ?>
				                </td>
				                <td>
				                    <?php if($this->session->userdata('c_v') == 1){ ?>
			                        <a data-toggle="modal" data-target="#modalEditar" style="font-size: 12px" class="btn btn-primary" onclick="setaEditar('<?php echo $f['fornecedor_cnpj'] ?>')"><i class="fas fa-eye"></i></a>
			                        &nbsp&nbsp
			                        <?php } ?>
			                        <?php if($this->session->userdata('c_e') == 1){ ?>
			                        <a href="<?php echo base_url('cadastros/editaFornecedor/').$f['fornecedor_cnpj'] ?>" class="btn btn-primary" style="font-size: 12px"><i class="fas fa-pencil-alt"></i></a>
			                        &nbsp&nbsp
			                        <?php } ?>
			                        <?php if($this->session->userdata('c_d') == 1){ ?>
			                        <a data-toggle="modal" data-target="#modalExcluir" class="btn btn-danger" style="font-size: 12px" onclick="setaExcluir('<?php echo $f['fornecedor_cnpj'] ?>')"><i class="fas fa-trash"></i></i></a>
			                        <?php } ?>
			                    </td>
				            </tr>
				            <?php }else if($this->session->userdata('c_a') == 1){ ?>
				            <tr <?php if($f['fornecedor_ativo_id'] == 2){echo "style='background-color: #eaeaea'";} ?>>
				                <td><?php echo mb_strtoupper($f['fornecedor_nome']) ?></td>
				                <td>
				                    <?php 
				                    $cnpj = substr($f['fornecedor_cnpj'], 0, 2).".".substr($f['fornecedor_cnpj'], 2, 3).".".substr($f['fornecedor_cnpj'], 5, 3)."/".substr($f['fornecedor_cnpj'], 8, 4)."-".substr($f['fornecedor_cnpj'], 12, 2);
				                    echo $cnpj;
				                    ?>
				                </td>
				                <td>
				                    <?php if($this->session->userdata('c_v') == 1){ ?>
			                        <a data-toggle="modal" data-target="#modalEditar" style="font-size: 12px" class="btn btn-primary" onclick="setaEditar('<?php echo $f['fornecedor_cnpj'] ?>')"><i class="fas fa-eye"></i></a>
			                        &nbsp&nbsp
			                        <?php } ?>
			                        <?php if($this->session->userdata('c_e') == 1){ ?>
			                        <a href="<?php echo base_url('cadastros/editaFornecedor/').$f['fornecedor_cnpj'] ?>" class="btn btn-primary" style="font-size: 12px"><i class="fas fa-pencil-alt"></i></a>
			                        &nbsp&nbsp
			                        <?php } ?>
			                        <?php if($this->session->userdata('c_d') == 1){ ?>
			                        <a data-toggle="modal" data-target="#modalExcluir" class="btn btn-danger" style="font-size: 12px" onclick="setaExcluir('<?php echo $f['fornecedor_cnpj'] ?>')"><i class="fas fa-trash"></i></i></a>
			                        <?php } ?>
			                    </td>
				            </tr>
				            <?php } } ?>
				        </tbody>
				        <tfoot>
				            <tr>
				                <th>Nome</th>
				                <th>CPNJ</th>
				                <th></th>
				            </tr>
				        </tfoot>
				    </table>
                </div>
                
                <br>
            </div>
        </div>
        
        <br><br>
        
    </section>
</section>

<div class="modal fade" id="modalExcluir" tabindex="-1" role="dialog" aria-labelledby="modalExcluirTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Mensagem do Sistema</h5>
            </div>
            <div class="modal-body">
                <h4>Deseja realmente excluir o fornecedor?</h4>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" style="border: 1px solid #4ECDC4; background-color: #4ECDC4; color: white; float: left" onclick="senha()">&nbsp&nbspSim&nbsp&nbsp</button>
                <button class="btn btn-danger" data-dismiss="modal">&nbsp&nbspNão&nbsp&nbsp</button>
                <br><br>
                <div class="row" id="formsenha" style="display: none">
                    <div class="col-md-12 text-center">
                        <form action="<?php echo base_url('cadastros/excluirFornecedor') ?>" method="post">
                            <input type="hidden" name="cnpjforn" id="cnpjforn">
                            <label style="font-size: 16px">Confirme a senha</label><br>
                            <input class="form-control" type="password" name="senha" id="senha" placeholder="Digite a Senha" required style="width: 50%; margin-left: 25%"><br>
                            <button type="submit" class="btn btn-primary" style="border: 1px solid #4ECDC4; background-color: #4ECDC4; color: white">&nbsp&nbspConfirmar&nbsp&nbsp</button>
                        </form>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditar" tabindex="-1" role="dialog" aria-labelledby="modalEditarTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalEditarTitle">Mensagem do Sistema</h5>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-7 form-group">
                        <label>Nome: &nbsp;</label><label id="nome" style="font-size: 16px; color: black"></label>
                    </div>
                    <div class="col-md-5 form-group">
                        <label>CNPJ: &nbsp;</label><label id="cnpj" style="font-size: 16px; color: black"></label>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-7 form-group">
                        <label>Representante: &nbsp;</label><label id="nome_r" style="font-size: 16px; color: black"></label>
                    </div>
                    <div class="col-md-5 form-group">
                        <label>Situação: </label><label id="ativo" style="font-size: 16px; color: black"></label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-danger" data-dismiss="modal">&nbsp&nbspVoltar&nbsp&nbsp</button>
            </div>
        </div>
    </div>
</div>

<script>
    function setaExcluir(cnpj){
        document.getElementById('cnpjforn').value = cnpj;
    }
    function senha(){
        document.getElementById('formsenha').style.display = "block";
    }
    function setaEditar(cnpj){
        dados = new FormData();
        dados.append('cnpj', cnpj);
        $.ajax({
            url: '<?php echo base_url('cadastros/getFornecedor'); ?>',
            method: 'post',
            data: dados,
            processData: false,
            contentType: false,
            error: function(xhr, status, error) {
              var err = eval("(" + xhr.responseText + ")");
              alert(err.Message);
            },
            success: function(data) {
                if(data != "null"){
                    var spl = data.split('|');
                    $('#nome').html(spl[0]);
                    $('#cnpj').html(spl[1]);
                    $('#nome_r').html(spl[2]);
                    $('#ativo').html(spl[3]);
                }else{
                    alert("Erro na banco");
                }
            },
        });
    }
</script>

<script>
    $(document).ready(function(){
        
        $('.js-example-basic-multiple').select2({theme: "bootstrap"});
        $('#myTableForn').DataTable( {
            "order": [[ 0, "asc" ]],
            "language": {
                "lengthMenu": "Mostrando _MENU_ registros por página",
                "zeroRecords": "Nada encontrado- refaça sua busca",
                "info": "Mostrando _PAGE_ de _PAGES_",
                "infoEmpty": "Sem registros disponíves",
                "infoFiltered": "(filtrado _MAX_ dos registros totais)",
                "sSearch":       "Procurar:",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Próximo",
                }
            },
            "columns": [
                {"Nome": "first", "orderable": true},
                {"CPNJ": "second", "orderable": false},
                {"Ação": "third", "orderable": false},
            ],
            initComplete: function () {
                this.api().columns([0]).every( function () {
                    var column = this;
                    var select = $('<select class="js-example-basic-multiple" style="width: 100%"><option value="">Todos</option></select>')
                        .appendTo( $(column.footer()).empty() )
                        .on( 'change', function () {
                            var val = $.fn.dataTable.util.escapeRegex(
                                $(this).val()
                            );
                             column
                                .search( val ? '^'+val+'$' : '', true, false )
                                .draw();
                                } );
       
                    column.data().unique().sort().each( function ( d, j ) {
                        select.append( '<option value="'+d+'">'+d+'</option>' )
                    } );
                } );
                this.api().columns([1]).every( function () {
                    var column = this;
                    var select = $('<select class="js-example-basic-multiple" style="width: 100%"><option value="">Todos</option></select>')
                        .appendTo( $(column.footer()).empty() )
                        .on( 'change', function () {
                            var val = $.fn.dataTable.util.escapeRegex(
                                $(this).val()
                            );
                             column
                                .search( val ? '^'+val+'$' : '', true, false )
                                .draw();
                                } );
       
                    column.data().unique().sort().each( function ( d, j ) {
                        select.append( '<option value="'+d+'">'+d+'</option>' )
                    } );
                } );
            }
        } );
    });
</script>