            <head>
                <link href="https://cdn.datatables.net/v/dt/jszip-3.10.1/dt-2.1.8/b-3.1.2/b-html5-3.1.2/r-3.0.3/datatables.min.css" rel="stylesheet">
            </head>

            <style>
                .tableFixHead {
                    overflow-y: auto;
                    height: 450px;
                }

                .tableFixHead thead th {
                    position: sticky;
                    top: 0;
                }

                /* Just common table stuff. Really. */
                table {
                    border-collapse: collapse;
                    width: 100%;

                }

                table td {
                    text-transform: uppercase;
                }

                th,
                td {
                    padding: 8px 16px;
                }

                th {
                    background: #eee;
                }

                #text-permissao th {
                    background: white;
                }

                .main-row {
                    padding-left: 10px;
                    padding-right: 10px;
                }

                .main-col-12 {
                    padding: 20px;
                    background-color: white;
                    border-radius: 5px;
                }

                .dataTables_wrapper .row {
                    width: 101%;
                    margin-bottom: 15px;
                }

                .pagination {
                    margin-top: 0px;
                }

                .dataTables_length label select {
                    margin-left: 10px;
                    margin-right: 10px;
                }

                .row-c {
                    width: 110%;
                    margin-bottom: 15px;
                }

                .btn-primary {
                    background-color: #033557;
                    border-color: #033557;
                }

                .btn-primary:hover {
                    background-color: #033557;
                    border-color: #033557;
                }

                .btn-primary:focus {
                    background-color: #033557;
                    border-color: #033557;
                }

                .btn-primary:not(:disabled):not(.disabled).active,
                .btn-primary:not(:disabled):not(.disabled):active,
                .show>.btn-primary.dropdown-toggle {
                    background-color: #033557;
                    border-color: #033557;
                }

                .pagination>.active>a {
                    background-color: #033557;
                }

                .pagination>.active>a:hover {
                    background-color: #033557;
                }

                .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
                    background: white;
                    border-color: white;
                }

                .btn-info-red {
                    float: right;
                    margin-right: 15px;
                    width: 25px;
                    height: 25px;
                    border: 2px solid black;
                    border-radius: 50%;
                    text-align: center;
                    color: red;
                    cursor: pointer;
                }

                .btn-info-red:hover {
                    color: black;
                }

                .swal2-title {
                    font-size: 25px;
                }

                .swal2-content {
                    font-size: 20px;
                }

                .swal2-styled.swal2-confirm {
                    font-size: 15px;
                }

                @media (min-width: 500px) {
                    .swal2-popup.swal2-modal.swal2-icon-info.swal2-show {
                        width: 40%;
                    }
                }

                .see-pass {
                    width: 10%;
                    margin-left: -4px;
                    margin-top: -2px;
                    border-top-left-radius: 0;
                    border-bottom-left-radius: 0;
                }

                .passwd {
                    width: 50%;
                    display: inline;
                    border-top-right-radius: 0;
                    border-bottom-right-radius: 0;
                }

                .encurtar {
                    display: -webkit-box;
                    overflow: hidden;
                    -webkit-line-clamp: 1;
                    -webkit-box-orient: vertical;
                    word-break: break-word;
                    line-height: 11px !important;
                }

                .modalCard {
                    width: 100%;
                    height: 100%;
                    overflow-y: hidden;
                    padding: 20px;
                    border-radius: 5px;
                    background-color: #00000073;
                    overflow-x: hidden;
                    position: absolute;
                    top: 0;
                    left: 0;
                    z-index: 99;
                    display: none;
                }

                .bordered {
                    border: 1px solid #ccc;
                    border-radius: 5px;
                    padding: 5px;
                    margin-left: 15px;
                }
            </style>

            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="container-fluid">

                <div class="row main-row">
                    <div class="col-md-12 main-col-12">

                        <div class="row main-row">
                            <?php /*if($this->session->userdata('editar') == 1 ){*/ ?>
                            <div style="margin-bottom: 10px">
                                <a class="btn btn-primary" style='color: white' data-toggle="modal" data-target="#modalItem" onclick="newForm()">Novo</a>
                            </div>

                            <div>
                                &nbsp;&nbsp;<a class="btn btn-primary" data-toggle="modal" data-target="#modalFiltro"><em class="fa fa-file-o"></em>&nbsp;&nbsp;PDF</a>
                            </div>
                            <div>
                                &nbsp;&nbsp;<a class="btn btn-primary" data-toggle="modal" data-target="#modalFiltroEXCEL"><em class="fa fa-file-o"></em>&nbsp;&nbsp;EXCEL</a>
                            </div>
                        </div>
                        <?php /*}*/ ?>
                        <?php if ($erro != null) { ?>
                            <div class="row" style="margin-bottom: 20px">
                                <div class="col-md-12">
                                    <h3 class="text-danger">Erro: A senha informada estava incorreta, por favor tente novamente!</h3>
                                </div>
                            </div>
                        <?php } ?>

                        <div class="input-group-append" style="position: absolute; right: 22px; height: 30px;top:75px; z-index: 2;">
                            <span style="background: white; border: 1px solid lightgrey" class="input-group-text" id="basic-addon2"><i style="font-size: 18px; cursor: pointer; color: #033557!important;" class="fa fa-search" aria-hidden="true"></i></span>
                        </div>

                        <div class="tableFixHead" style="height: auto;">
                            <table id="myTableFunc" class="table table-hover table-bordered">
                                <thead>
                                    <tr>
                                        <th style="width: 3%">Solicitação</th>
                                        <th style="width: 5%">Veículo</th>
                                        <th style="width: 13%">Motorista</th>
                                        <th style="width: 13%">Emissor</th>
                                        <th style="width: 12%">Item</th>
                                        <th style="width: 5%">Peso Líquido</th>
                                        <th style="width: 15%">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($itens as $itm) { ?>
                                        <tr>
                                            <td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo ucwords('AB' . str_pad($itm['tk_solicitacao_id'], 6, '0', STR_PAD_LEFT)); ?>">
                                                    <?php echo ucwords(str_pad($itm['tk_solicitacao_id'], 6, '0', STR_PAD_LEFT)) ?>
                                                </div>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo $itm['veiculo']['placa'] ?>">
                                                    <?php echo strtolower($itm['veiculo']['placa']) ?>
                                                </div>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo $itm['motorista_nome'] ?>">
                                                    <?php echo $itm['motorista_nome'] ?>
                                                </div>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo $itm['cliente_nome'] ?>">
                                                    <?php echo $itm['cliente_nome'] ?>
                                                </div>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <div class="" title="<?php echo $itm['produto_nome'] ?>">
                                                    <?php echo $itm['produto_nome'] ?>
                                                </div>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <?php echo $itm['tk_peso_liquido'] ?>
                                            </td>
                                            <!--<td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php //echo $itm['tk_descricao'] 
                                                                                ?>">
                                                    <?php //echo $itm['tk_descricao'] 
                                                    ?>
                                                </div>
                                            </td>-->
                                            <td >
                                                <a style="font-size: 10px;padding: 5px 10px" data-toggle="modal" data-target="#modalItem" onclick='openItem(JSON.stringify(<?php echo json_encode($itm) ?>))' class="btn btn-primary btn-modal-toggle mb-1"><i class="fas fa-eye"></i></a>
                                                <a style="font-size: 10px;padding: 5px 10px" href="<?php echo base_url('relatoriosingleticketpesagem/' . $itm['tk_id']) ?>" target="_blank" class="btn btn-primary btn-modal-toggle mb-1"> <i class="fa fa-file-o"></i> </a>
                                                <a style="font-size: 10px;padding: 5px 10px" data-toggle="modal" data-target="#modalItem" onclick='openItem(JSON.stringify(<?php echo json_encode($itm) ?>), true)' class="btn btn-primary"><i class="fas fa-pencil-alt"></i></a>
                                                <?php /*if ($this->session->userdata('excluir') == 1) {*/ ?>
                                                <a data-toggle="modal" data-target="#modalExcluir" class="btn btn-danger" style="font-size: 10px;padding: 5px 10px" onclick="setaExcluir('<?php echo $itm['tk_id']; ?>')"><i class="fas fa-trash"></i></i></a>
                                                <?php //} 
                                                ?>

                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>

            </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->
            <div class="modal fade " id="modalItem" tabindex="-1" role="dialog" aria-labelledby="modalItemTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header" style="text-align: left; justify-content: unset;">
                            <h5 class="modal-title" id="exampleModalLongTitle">Mensagem do Sistema</h5>
                        </div>
                        <form action="<?php echo base_url('ticketpesagem/novoitem'); ?>" method="post" enctype='multipart/form-data'>
                            <div class="modal-body">
                                <h4>Ticket de Pesagem</h4>

                                <div class="row">
                                    <input class="inputItem" name="tk_id" id="tk_id" type="hidden">

                                    <div class="col-md-6 form-group">
                                        <label for="tk_carreta_id" class="form-label">Carreta</label>
                                        <select class="form-control select2-input inputItem " style="width:100%;" id="tk_carreta_id" name="tk_carreta_id" required>
                                            <option selected disabled>-- Selecionar --</option>
                                            <?php foreach ($veiculos as $veic) { ?>
                                                <option value="<?php echo $veic['id']; ?>"> <?php echo $veic['nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="tk_veiculo_id" class="form-label">Veículo</label>
                                        <select class="form-control select2-input inputItem " style="width:100%;" id="tk_veiculo_id" name="tk_veiculo_id" required>
                                            <option selected disabled>-- Selecionar --</option>
                                            <?php foreach ($veiculos as $veic) { ?>
                                                <option value="<?php echo $veic['id']; ?>"> <?php echo $veic['nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="tk_cliente_cpfcnpj" class="form-label">Emissor/Cliente</label><br>
                                        <select class="form-control select2-input inputItem" style="width: 100%" name="tk_cliente_cpfcnpj" id="tk_cliente_cpfcnpj" required>
                                            <option selected disabled>-- Selecionar --</option>
                                            <?php foreach ($clientes as $cliente) { ?>
                                                <option value="<?php echo $cliente['cliente_cpfcnpj'] ?>"
                                                    <?php /*if ($cliente['cliente_cnpj'] == $edita['tk_cliente_id']) {
                                                        echo "selected";
                                                    } */ ?>>
                                                    <?php echo $cliente['cliente_nome'] ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="tk_item_id" class="form-label">Item</label>
                                        <select class="form-control inputItem select2-input" style="width:100%;" id="tk_item_id" name="tk_item_id" required>
                                            <option selected disabled>-- Selecionar --</option>
                                            <?php foreach ($produtos as $veic) { ?>
                                                <option value="<?php echo $veic['produto_id']; ?>"> <?php echo $veic['produto_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="tk_motorista_id">Motorista</label><br>
                                        <select class="select2-input form-control inputItem" style="width: 100%" name="tk_motorista_id" id="tk_motorista_id" required>
                                            <option selected disabled>-- Selecionar --</option>
                                            <?php foreach ($motoristas as $motorista) { ?>
                                                <option value="<?php echo $motorista['motorista_id'] ?>"
                                                    <?php /*if ($motorista['motorista_id'] == $edita['tk_motorista_id']) {
                                                        echo "selected";
                                                    } */ ?>>
                                                    <?php echo $motorista['motorista_nome'] ?>
                                                </option>
                                            <?php  } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="tk_transportadora">Transportadora</label>
                                        <input class="form-control" name="tk_transportadora" id="tk_transportadora" value="<?= $config['cfgc_empresa'] ?>" placeholder="JC Transportes" required disabled>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="tk_ticket_pesagem">Ticket de Pesagem</label>
                                        <input required class="form-control inputItem" name="tk_ticket_pesagem" id="tk_ticket_pesagem">
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="tk_unidade">Unidade</label>
                                        <input required class="form-control inputItem" name="tk_unidade" id="tk_unidade">
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="tk_diferenca_origem">Diferença de origem</label>
                                        <input class="form-control inputItem" name="tk_diferenca_origem" id="tk_diferenca_origem">
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="tk_unidade">Número da Nota</label>
                                        <input required class="form-control inputItem" name="tk_numero_nota" id="tk_numero_nota">
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="tk_quantidade_carregar">Quantidade a Carregar (kg)</label>
                                        <input required class="form-control inputItem peso" name="tk_quantidade_carregar" id="tk_quantidade_carregar">
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="tk_tipo_veiculo">Tipo de Veículo</label>
                                        <input required class="form-control inputItem" name="tk_tipo_veiculo" id="tk_tipo_veiculo">
                                    </div>

                                    <div class="col-md-3 form-group">
                                        <label for="tk_tipo_movimento">Tipo de Movimento</label>
                                        <input required class="form-control inputItem" name="tk_tipo_movimento" id="tk_tipo_movimento">
                                    </div>

                                    <div class="col-md-3 form-group">
                                        <label for="tk_deposito">Doca/Depósito</label>
                                        <input required class="form-control inputItem" name="tk_deposito" id="tk_deposito">
                                    </div>

                                    <div class="col-md-3 form-group">
                                        <label for="tk_peso_liquido">Peso Líquido (kg)</label>
                                        <input required class="form-control inputItem peso" name="tk_peso_liquido" id="tk_peso_liquido">
                                    </div>

                                    <div class="col-md-3 form-group">
                                        <label for="tk_data">Data</label>
                                        <input required type="date" class="form-control inputItem" name="tk_data" id="tk_data">
                                    </div>

                                    <div class="col-md-12">
                                        <label class="">Pré-Entrada</label>
                                    </div>
                                    <div class="row bordered" style="width: 96%;">
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pre_data">Data/Hora</label>
                                            <input required type="datetime-local" class="form-control inputItem" name="tk_pre_data" id="tk_pre_data">
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pre_operador">Operador</label>
                                            <input required class="form-control inputItem" name="tk_pre_operador" id="tk_pre_operador">
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pre_motorista">Motorista</label>
                                            <input required class="form-control inputItem" name="tk_pre_motorista" id="tk_pre_motorista">
                                        </div>
                                    </div>

                                    <div class="col-md-12 mt-4">
                                        <label class="">Pesagem Inicial</label>
                                    </div>
                                    <div class="row bordered" style="width: 96%;">
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pi_data">Data/Hora</label>
                                            <input required type="datetime-local" class="form-control inputItem" name="tk_pi_data" id="tk_pi_data">
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pi_balanca">Balança</label>
                                            <input required class="form-control inputItem" name="tk_pi_balanca" id="tk_pi_balanca">
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pi_peso">Peso (kg)</label>
                                            <input required class="form-control inputItem peso" name="tk_pi_peso" id="tk_pi_peso">
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pi_operador">Operador</label>
                                            <input required class="form-control inputItem" name="tk_pi_operador" id="tk_pi_operador">
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pi_motorista">Motorista</label>
                                            <input required class="form-control inputItem" name="tk_pi_motorista" id="tk_pi_motorista">
                                        </div>
                                    </div>

                                    <div class="col-md-12 mt-4">
                                        <label class="">Pesagem Final</label>
                                    </div>

                                    <div class="row bordered" style="width: 96%;">
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pf_data">Data/Hora</label>
                                            <input required type="datetime-local" class="form-control inputItem" name="tk_pf_data" id="tk_pf_data" type="number">
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pf_balanca">Balança</label>
                                            <input required class="form-control inputItem" name="tk_pf_balanca" id="tk_pf_balanca">
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pf_peso">Peso (kg)</label>
                                            <input required class="form-control inputItem peso" name="tk_pf_peso" id="tk_pf_peso">
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pf_operador">Operador</label>
                                            <input required class="form-control inputItem" name="tk_pf_operador" id="tk_pf_operador">
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <label for="tk_pf_motorista">Motorista</label>
                                            <input required class="form-control inputItem" name="tk_pf_motorista" id="tk_pf_motorista">
                                        </div>
                                    </div>

                                    <div class="col-md-12 form-group mt-5">
                                        <label for="tk_observacao">Observação</label>
                                        <textarea rows="3" class="form-control inputItem" name="tk_observacao" id="tk_observacao">
                                        </textarea>
                                    </div>

                                    <div class="col-md-6  mt-4">
                                        <div class="input-group" id="inputImageFile">
                                            <div class="row" style="margin: 0">
                                                <label class="preset-docs-docs-doc-title" style="float:left;">Anexo</label>
                                            </div>
                                            <div class="row" style="margin: 0">
                                                <input
                                                    type="text" class="form-control"
                                                    placeholder="Selecione um arquivo" id="5-file"
                                                    value="<?php if (isset($_GET['edicao_id'])) {
                                                            } ?>" disabled style="width: 100%" />
                                                <div class="input-group-append" style="width: 100%">
                                                    <input
                                                        id="5-doc" type="file" name="5-doc" class="file"
                                                        accept=".jpg, .jpeg, .png" style="display:none;"
                                                        onchange="triggerInputFile(this.id, event)" />
                                                    <button id="5-search" type="button" class="browse btn btn-primary" style="width:100%">Buscar...</button>
                                                </div>
                                            </div>

                                            <small class="preset-docs-docs-doc-title mt-2 mb-2 text-muted" style="float:left;">Formatos permitidos: .jpg, .jpeg, .png</small>

                                        </div>
                                        <div class="row" style="margin: 0;display:none;" id="body-btn-img">
                                            <div class="col-md-10" style="margin:0;margin-top: 25px;width: 80%">
                                                <a href="/uploads/" target="_blank" id="btn-img" class="btn btn-primary" style="width: 100%;margin:0;">Clique para ver a imagem</a>
                                            </div>
                                            <div class="col-md-2" style="width:20%;font-size: 12px;margin-top: 25px;margin-left: 10px">
                                                <a class="btn btn-danger" style="font-size: 12px" onclick="onDeleteAnexo('<?php echo $itm['tk_id']; ?>',1)"><i class="fas fa-trash"></i></i></a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6  mt-4 ">
                                        <div class="input-group" id="2inputImageFile">
                                            <div class="row" style="margin: 0">
                                                <label class="preset-docs-docs-doc-title" style="float:left;">Anexo</label>
                                            </div>
                                            <div class="row" style="margin: 0">
                                                <input
                                                    type="text" class="form-control"
                                                    placeholder="Selecione um arquivo" id="6-file"
                                                    value="<?php if (isset($_GET['edicao_id'])) {
                                                            } ?>" disabled style="width: 100%" />
                                                <div class="input-group-append" style="width: 100%">
                                                    <input
                                                        id="6-doc" type="file" name="6-doc" class="file"
                                                        accept=".jpg, .jpeg, .png" style="display:none;"
                                                        onchange="triggerInputFile(this.id, event)" />
                                                    <button id="6-search" type="button" class="browse btn btn-primary" style="width:100%">Buscar...</button>
                                                </div>
                                            </div>

                                            <small class="preset-docs-docs-doc-title mt-2 mb-2 text-muted" style="float:left;">Formatos permitidos: .jpg, .jpeg, .png</small>

                                        </div>
                                        <div class="row" style="margin: 0;display:none;" id="2body-btn-img">
                                            <div class="col-md-10" style="margin:0;margin-top: 25px;width: 80%">
                                                <a href="/uploads/" target="_blank" id="2btn-img" class="btn btn-primary" style="width: 100%;margin:0;">Clique para ver a imagem</a>
                                            </div>
                                            <div class="col-md-2" style="width:20%;font-size: 12px;margin-top: 25px;margin-left: 10px">
                                                <a class="btn btn-danger" style="font-size: 12px" onclick="onDeleteAnexo('<?php echo $itm['tk_id']; ?>',2)"><i class="fas fa-trash"></i></i></a>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="modal-footer" style="position: relative">
                                <button class="btn btn-danger" data-dismiss="modal" type="button" onclick="closemodal()">Cancelar</button>
                                <button class="btn btn-primary" id="btn-salvar" type="submit">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="modalFiltroEXCEL" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">

                        <div class="modal-header">
                            <div class="row row-c">
                                <div class="col-md-10">
                                    <h4 class="modal-title">Filtros</h4>
                                </div>
                                <div class="col-md-2 text-right">
                                    <button type="button" class="close" onclick="hideFiltro()" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <form action="<?php echo base_url('relatorioexcelticketpesagem') ?>" method="post" target="_blank">
                            <div class="modal-body ">
                                <div class="row">
                                    <div class="col-md-4 form-group">
                                        <label id="importancia">Data inicial</label>
                                        <input class="form-control" onchange='dateIsOlder("inicioE", "fimE")' id="inicioE" name="inicio" type="date">
                                    </div>
                                    <div class="col-md-4 form-group">
                                        <label id="importancia">Data final</label>
                                        <input class="form-control" onchange='dateIsOlder("inicioE", "fimE")' id="fimE" name="fim" type="date">
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="motorista_id" class="form-label">Motorista</label>
                                        <select class="form-control select2-input_filtro" style="width:100%;" name="motorista_id">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($motoristas as $moto) { ?>
                                                <option value="<?php echo $moto['motorista_id']; ?>"> <?php echo $moto['motorista_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="cliente_cpfcnpj">Emissor</label><br>
                                        <select class="form-control select2-input_filtroE" style="width: 100%!important" name="cliente_cpfcnpj">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($clientes as $cliente) { ?>
                                                <option value="<?php echo $cliente['cliente_cpfcnpj'] ?>"> <?php echo $cliente['cliente_nome'] ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="veiculo_id" class="form-label">Veículo</label>
                                        <select class="form-control select2-input_filtroE " style="width:100%;" name="veiculo_id">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($veiculos as $veic) { ?>
                                                <option value="<?php echo $veic['id']; ?>"> <?php echo $veic['nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="item_id" class="form-label">Item</label>
                                        <select class="form-control select2-input_filtroE" style="width:100%;" name="item_id">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($produtos as $veic) { ?>
                                                <option value="<?php echo $veic['produto_id']; ?>"> <?php echo $veic['produto_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>


                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger" onclick="hideFiltro()">Cancelar</button>
                                &nbsp;&nbsp;
                                <button type="submit" class="btn btn-primary">Gerar EXCEL</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <div class="modal fade " id="modalFiltro" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">

                        <div class="modal-header">
                            <div class="row row-c">
                                <div class="col-md-10">
                                    <h4 class="modal-title">Filtros</h4>
                                </div>
                                <div class="col-md-2 text-right">
                                    <button type="button" class="close" onclick="hideFiltro()" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <form action="<?php echo base_url('relatorioticketpesagem') ?>" method="post" target="_blank">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-4 form-group">
                                        <label id="importancia">Data inicial</label>
                                        <input class="form-control" onchange='dateIsOlder("inicio", "fim")' id="inicio" name="inicio" type="date">
                                    </div>
                                    <div class="col-md-4 form-group">
                                        <label id="importancia">Data final</label>
                                        <input class="form-control" onchange='dateIsOlder("inicio", "fim")' id="fim" name="fim" type="date">
                                    </div>
                                    <div class="col-md-4 form-group">
                                        <label for="motorista_id" class="form-label">Motorista</label>
                                        <select class="form-control select2-input_filtro" style="width:100%;" name="motorista_id">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($motoristas as $moto) { ?>
                                                <option value="<?php echo $moto['motorista_id']; ?>"> <?php echo $moto['motorista_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="cliente_cpfcnpj">Emissor</label><br>
                                        <select class="form-control select2-input_filtro" style="width: 100%!important" name="cliente_cpfcnpj">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($clientes as $cliente) { ?>
                                                <option value="<?php echo $cliente['cliente_cpfcnpj'] ?>"> <?php echo $cliente['cliente_nome'] ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="veiculo_id" class="form-label">Veículo</label>
                                        <select class="form-control select2-input_filtro " style="width:100%;" name="veiculo_id">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($veiculos as $veic) { ?>
                                                <option value="<?php echo $veic['id']; ?>"> <?php echo $veic['nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="item_id" class="form-label">Item</label>
                                        <select class="form-control select2-input_filtro" style="width:100%;" name="item_id">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($produtos as $veic) { ?>
                                                <option value="<?php echo $veic['produto_id']; ?>"> <?php echo $veic['produto_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger" onclick="hideFiltro()">Cancelar</button>
                                &nbsp;&nbsp;
                                <button type="submit" class="btn btn-primary">Gerar PDF</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <div class="modal fade" id="modalExcluir" tabindex="-1" role="dialog" aria-labelledby="modalExcluirTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <form action="<?php echo base_url('ticketpesagem/deletar') ?>" method="post">
                        <input type="hidden" name="tk_id" id="tk_id_delete">
                        <div class="modal-content">
                            <div class="modal-header" style="text-align: left; justify-content: unset;">
                                <h5 class="modal-title" id="exampleModalLongTitle">Mensagem do Sistema</h5>
                            </div>
                            <div class="modal-body">
                                <h4>Deseja realmente excluir este item?</h4>
                            </div>
                            <div class="modal-footer" style="position: relative">
                                <button class="btn btn-primary" style="position: absolute; top: 15px; left: 15px; color: white; float: left" onclick="senha()">&nbsp&nbspSim&nbsp&nbsp</button>
                                <button class="btn btn-danger" data-dismiss="modal">&nbsp&nbspNão&nbsp&nbsp</button>
                                <br><br>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="modal fade" id="modalExcluirAnexo" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                        <input type="hidden" name="id_anexo" id="id_anexo">
                        <input type="hidden" name="id_index" id="id_index">
                        <div class="modal-content">
                            <div class="modal-header" style="text-align: left; justify-content: unset;">
                                <h5 class="modal-title" id="exampleModalLongTitle">Mensagem do Sistema</h5>
                            </div>
                            <div class="modal-body">
                                <h4>Deseja realmente excluir este anexo?</h4>
                            </div>
                            <div class="modal-footer" style="position: relative">
                                <button class="btn btn-primary" style="position: absolute; top: 15px; left: 15px; color: white; float: left" onclick="deleteAnexo()">&nbsp&nbspSim&nbsp&nbsp</button>
                                <button class="btn btn-danger" data-dismiss="modal">&nbsp&nbspNão&nbsp&nbsp</button>
                                <br><br>
                            </div>
                        </div>
                </div>
            </div>

            <script>
                $(document).on("click", ".browse", function() {
                    var id = this.id;
                    id = id.replaceAll("-search", "");
                    var file = $(this).parents().find("#" + id + "-doc");
                    file.prop("disabled", false);
                    file.trigger("click");
                });

                $('input[type="file"]').change(function(e) {
                    var fileID = this.id;
                    fileID = fileID.replaceAll("-doc", "");
                    var fileName = e.target.files[0].name;
                    $("#" + fileID + "-file").val(fileName);

                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (e.target.result.includes('data:image/')) {
                            //document.getElementById(fileID + "-preview").src = e.target.result;
                        } else {
                            //document.getElementById(fileID + "-preview").src = '<?php echo base_url('resources/imgs/pdf_cover.png') ?>';
                        }
                    };
                    reader.readAsDataURL(this.files[0]);
                });

                function triggerInputFile(id, e) {
                    var fileID = id;
                    fileID = fileID.replaceAll("-doc", "");
                    var fileName = e.target.files[0].name;
                    $("#" + fileID + "-file").val(fileName);

                    var reader = new FileReader();
                    reader.onload = function(e) {
                        document.getElementById(fileID + "-preview").src = e.target.result;
                    };
                    reader.readAsDataURL(e.target.files[0]);
                }
            </script>

            <script>
                function dateIsOlder(input1, input2) {
                    const inicio = new Date($('#' + input1).val());
                    const fim = new Date($('#' + input2).val());
                    if (fim < inicio) {
                        alert('A data final deve ser maior que a inicial');
                        $('#' + input1).val('');
                        $('#' + input2).val('');
                    }
                }

                function newForm() {
                    $('.modalCard').css('display', 'block');
                    $('#btn-salvar').css('display', 'block');
                    $('#btn-img').attr('href', '');
                    $('.body_value').css('background-color', 'white');
                    $('#body-btn-img').attr('style', 'display: none');
                    $('#inputImageFile').attr('style', 'display: block');

                    const inputs = document.querySelectorAll('.inputItem');
                    inputs.forEach(input => {
                        input.value = '';
                    });
                    toggleInputs(true)

                }

                function toggleInputs(status) {
                    const inputs = document.querySelectorAll('.inputItem');
                    inputs.forEach(input => {
                        if (status) {
                            input.disabled = false;
                        } else {
                            input.disabled = true;
                        }
                    });

                    if (status) {
                        $('#btn-salvar').css('display', 'block');
                    } else {
                        $('#btn-salvar').css('display', 'none');

                    }
                }

                function closemodal() {
                    $('.modalCard').css('display', 'none');
                }

                function openItem(item, edit) {
                    $('.modalCard').css('display', 'block');

                    toggleInputs(edit);

                    setTimeout(() => {
                        const values = JSON.parse(item);

                        $('#tk_id').val(values?.tk_id);
                        $('#tk_data').val(values?.tk_data);
                        $('#tk_ticket_pesagem').val(values?.tk_ticket_pesagem);
                        $('#tk_unidade').val(values?.tk_unidade);
                        $('#tk_transportadora').val(values?.tk_transportadora);
                        $('#tk_tipo_movimento').val(values?.tk_tipo_movimento);
                        $('#tk_deposito').val(values?.tk_deposito);
                        $('#tk_tipo_veiculo').val(values?.tk_tipo_veiculo);
                        $('#tk_peso_liquido').val(values?.tk_peso_liquido);
                        $('#tk_quantidade_carregar').val(values?.tk_quantidade_carregar);
                        $('#tk_pre_data').val(values?.tk_pre_data);
                        $('#tk_pre_operador').val(values?.tk_pre_operador);
                        $('#tk_pre_motorista').val(values?.tk_pre_motorista);
                        $('#tk_pi_data').val(values?.tk_pi_data);
                        $('#tk_pi_balanca').val(values?.tk_pi_balanca);
                        $('#tk_pi_peso').val(values?.tk_pi_peso);
                        $('#tk_pi_operador').val(values?.tk_pi_operador);
                        $('#tk_pi_motorista').val(values?.tk_pi_motorista);
                        $('#tk_pf_data').val(values?.tk_pf_data);
                        $('#tk_pf_balanca').val(values?.tk_pf_balanca);
                        $('#tk_pf_peso').val(values?.tk_pf_peso);
                        $('#tk_pf_operador').val(values?.tk_pf_operador);
                        $('#tk_pf_motorista').val(values?.tk_pf_motorista);
                        $('#tk_numero_nota').val(values?.tk_numero_nota);
                        $('#tk_observacao').val(values?.tk_observacao);
                        $('#tk_diferenca_origem').val(values?.tk_diferenca_origem);

                        if (values?.tk_anexo != null) {
                            document.getElementById('btn-img').href = '/uploads/' + values?.tk_anexo;
                            document.getElementById('body-btn-img').style.display = 'block';
                            document.getElementById('inputImageFile').style.display = 'none';
                        }

                        if (values?.tk_anexo2 != null) {
                            document.getElementById('2btn-img').href = '/uploads/' + values?.tk_anexo2;
                            document.getElementById('2body-btn-img').style.display = 'block';
                            document.getElementById('2inputImageFile').style.display = 'none';
                        }

                        $('#tk_cliente_cpfcnpj').val(values?.tk_cliente_cpfcnpj).trigger('change');
                        $('#tk_motorista_id').val(values?.tk_motorista_id).trigger('change');
                        $('#tk_carreta_id').val(values?.tk_carreta_id).trigger('change');
                        $('#tk_veiculo_id').val(values?.tk_veiculo_id).trigger('change');
                        $('#tk_item_id').val(values?.tk_item_id).trigger('change');

                    }, 500);

                }
            </script>

            <script>
                $(document).ready(function() {

                    $('.select2-input').select2({
                        theme: "bootstrap",
                        dropdownParent: $('#modalItem')
                    });

                    $('.select2-input_filtro').select2({
                        theme: "bootstrap",
                        dropdownParent: $('#modalFiltro')
                    });

                    $('.select2-input_filtroE').select2({
                        theme: "bootstrap",
                        dropdownParent: $('#modalFiltroEXCEL')
                    });

                    $('.peso').mask('#0.000', {
                        reverse: true
                    });

                    /*document.getElementById('tk_data_validade').value = "<?php echo date('Y-m-d'); ?>";

                    $('#tk_valor').mask('000000000000000.00', {
                        reverse: true
                    });*/

                    $('#myTableFunc').DataTable({
                        layout: {
                            topStart: 'buttons',
                        },
                        "order": [
                            [0, "desc"]
                        ],
                        "buttons": [{
                            extend: 'excelHtml5',
                            text: 'EXCEL',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5] // Define quais colunas exportar (a coluna de índice 3 será omitida)
                            }
                        }],
                        "language": {
                            "lengthMenu": "Mostrando _MENU_",
                            "zeroRecords": "Nada encontrado- refaça sua busca",
                            "info": "Mostrando _PAGE_ de _PAGES_",
                            "infoEmpty": "Sem registros disponíves",
                            "infoFiltered": "(filtrado _MAX_ dos registros totais)",
                            "sSearch": "Procurar:",
                            "searchPlaceholder": "Digite sua busca",
                            "paginate": {
                                "previous": "Anterior",
                                "next": "Próximo",
                            }
                        },
                        "columns": [{
                                "Solicitação": "first",
                                "orderable": true
                            },
                            {
                                "Validade": "first",
                                "orderable": true
                            },
                            {
                                "Motorista": "second",
                                "orderable": true
                            },
                            {
                                "Fornecedor": "third",
                                "orderable": true
                            },
                            {
                                "Valor": "fourth",
                                "orderable": true
                            },
                            {
                                "Qtd": "fourth",
                                "orderable": true
                            },
                            /*{
                                "Descrição": "fourth",
                                "orderable": true
                            },*/
                            {
                                "Ação": "fourth",
                                "orderable": false
                            },
                        ],
                    });

                    $('.buttons-excel').addClass('hidden');
                    $('#btn-excel').on('click', function() {
                        $('.buttons-excel').click();
                    })
                });

                function onDeleteAnexo(id, index) {
                    $('#modalExcluirAnexo').modal('show');
                    $('#id_anexo').val(id);
                    $('#id_index').val(index);
                }

                function deleteAnexo() {
                    var form = new FormData();

                    form.append('id', $('#tk_id').val());
                    form.append('index', $('#id_index').val());

                    $.ajax({
                        type: "post",
                        url: "/deleteAnexo",
                        data: form,
                        processData: false,   // Evita que o jQuery processe os dados
                        contentType: false,
                        success: function(data) {
                            if($('#id_index').val() == 1){
                                document.getElementById('btn-img').href = '';
                                document.getElementById('body-btn-img').style.display = 'none';
                                document.getElementById('inputImageFile').style.display = 'block';
                            }

                            if($('#id_index').val() == 2){
                                document.getElementById('2btn-img').href = '';
                                document.getElementById('2body-btn-img').style.display = 'none';
                                document.getElementById('2inputImageFile').style.display = 'block';
                            }

                            $('#modalExcluirAnexo').modal('hide');
                        },
                        error: function(data) {
                            console.log('error', {data});
                        }
                    })

                    
                }
            </script>

            <script>
                function setaExcluir(id) {
                    document.getElementById('tk_id_delete').value = id;
                }
            </script>

            <script>
                function hideFiltro() {
                    //$('#filtro_marca').val('').change();
                    //$('#filtro_situacao').val('').change();

                    $('#modalFiltro').modal('hide');
                    $('#modalFiltroEXCEL').modal('hide');
                }
                $('#modalFiltro').on('hidden.bs.modal', function() {
                    hideFiltro();
                });
            </script>