<style>
    .span-data {
        font-weight: bold;
    }

    .td-impar {
        background-color: #eee !important;
    }

    .inside-table {
        width: 100%;
    }

    .inside-table tr {
        font-size: 11px;
    }

    .inside-table tr:hover {
        background-color: #eee !important;
    }

    .inside-table td {
        border: 0;
    }

    .inside-table th {
        border: 0;
        border-bottom: 0px !important;
    }

    .sep-tr {
        border-top: 2px solid lightgrey;
    }

    .title-inside {
        font-weight: bold;
    }
</style>
<div class="row">
    <div class="col-md-12" id="main" style="padding: 20px 40px">
        <br><br>
        <div class="row">
            <div class="col-md-12 form-group text-center">
                <button onclick="pdf()" id="pdf" class="btn btn-primary" style="float: left">.PDF</button>
                <img src="<?php echo base_url('resources/imgs/banner.png') ?>" style="width: 35%; height: auto">
                <br><br>
                <h3 style="font-weight: bold">Relatório Vale Refeição
                    <?php
                    date_default_timezone_set('America/Sao_Paulo');
                    if (!empty($filtros['inicio'])) {
                        echo ' de ' . date('d/m/Y', strtotime($filtros['inicio'])) . ' a ' . date('d/m/Y', strtotime($filtros['fim']));
                    } else {
                        echo date('d/m/Y');
                    }  ?></h3>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 form-group">
                <table class="table table-hover table-bordered">
                    <thead>
                        <tr style="background-color: #eee;">
                            <th style="width: 6%">Solicitação</th>

                            <th style="width: 8%">Validade</th>
                            <th style="width: 25%">Motorista</th>
                            <th style="width: 25%">Fornecedor</th>
                            <th style="width: 10%">Valor</th>
                            <th style="width: 5%">Quantidade</th>
                            <!--<th style="width: 25%">Descricão</th>-->
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $quantidade = 0;
                        $total = 0;
                        foreach ($itens as $c) { ?>
                            <tr>
                                <td><?php echo $c['vr_solicitacao_id']    ?></td>
                                <td><?php echo date('d/m/Y', strtotime($c['vr_data_validade'])) ?></td>
                                <td><?php echo $c['motorista_nome'] ?></td>
                                <td><?php echo $c['fornecedor_nome'] ?></td>
                                <td>R$ <?php echo number_format($c['vr_valor'], 2, ',', '.') ?></td>
                                <td><?php echo $c['vr_quantidade'] ?></td>
                                <!--<td><?php echo $c['vr_descricao'] ?></td>-->
                            </tr>
                        <?php  $total += $c['vr_valor']; $quantidade += $c['vr_quantidade']; } ?>
                    </tbody>
                </table>
                <br> <br>
                <p class="text-right"><label>Quantidade: <?= $quantidade ?> </label> </p>
                <p class="text-right"><label class="ml-3">Total: R$ <?= number_format($total, 2, ',', '.') ?></label></p>

            </div>
        </div>

        <footer id="footer" style="position: fixed; bottom: 0; text-align: center; width: 100%; margin-bottom: -30px; display: none">
            <div class="row">
                <div class="col-md-5 text-left">
                    <p><b>Vale Refeição | <?php echo date('d/m/Y - H:i:s') ?></b></p>
                </div>
                <div class="col-md-6 text-right">
                    <p>Gerenciamento de Frotas | N Soluções</p>
                </div>
            </div>
            <br><br>
        </footer>

    </div>
</div>

<script>
    function pdf() {
        $('#pdf').css('display', 'none');
        $('#footer').css('display', 'block');
        window.print();
        $('#footer').css('display', 'none');
        $('#pdf').css('display', 'block');
    }
</script>