<?php
function mascaraCelular($numero)
{
    // Remove todos os caracteres que não são números
    $numero = preg_replace('/\D/', '', $numero);

    // Verifica se o número tem 11 dígitos (DDD + número de celular com 9 dígitos)
    if (strlen($numero) == 11) {
        // Formata como (XX) XXXXX-XXXX
        return preg_replace('/(\d{2})(\d{5})(\d{4})/', '($1) $2-$3', $numero);
    }

    if (strlen($numero) == 10) {
        // Formata como (XX) XXXXX-XXXX
        return preg_replace('/(\d{2})(\d{4})(\d{4})/', '($1) $2-$3', $numero);
    }
    // Caso o número não tenha 11 dígitos, retorna o número original
    return $numero;
}

?>
<style>
    .span-data {
        font-weight: bold;
    }

    .td-impar {
        background-color: #eee !important;
    }

    .inside-table {
        width: 100%;
    }

    .inside-table tr {
        font-size: 11px;
    }

    .inside-table tr:hover {
        background-color: #eee !important;
    }

    .inside-table td {
        border: 0;
    }

    .inside-table th {
        border: 0;
        border-bottom: 0px !important;
    }

    .sep-tr {
        border-top: 2px solid lightgrey;
    }

    .title-inside {
        font-weight: bold;
    }

    .signature-line {
        width: 50%;
        border-top: 1px solid #000;
        margin: 5px auto 0 auto;
        text-align: center;
    }

    .footer-text {
        font-size: 12px;
    }

    .pdf-icon {
        margin-left: 10px;
        cursor: pointer;
    }

    table thead th {
        font-size: 14px
    }

    table tbody tr td {
        font-size: 16px;
        text-transform: uppercase;
    }
</style>


<div class="row">

    <div class="col-md-12 form-group text-center m-2">
        <button onclick="pdf()" id="pdf" class="btn btn-primary" style="float: left">.PDF</button>
    </div>

    <div class="col-md-12" id="main">
        <!-- Cabeçalho -->

        <div class="row" style="justify-content: center;">

            <div class="col-md-4 col-sm-4 form-group text-center">
                <center><img src="<?php echo base_url('resources/imgs/logotemp.png') ?>" style="width: 60%; height: auto;margin-left: 60px"></center>
            </div>

            <div class="col-md-7 col-sm-7 form-group text-center">
                <h3 style="font-weight: bold">
                    Autorização de Vale Refeição
                    <?php
                    date_default_timezone_set('America/Sao_Paulo');
                    if (!empty($filtros['inicio'])) {
                        echo ' de ' . date('d/m/Y', strtotime($filtros['inicio'])) . ' a ' . date('d/m/Y', strtotime($filtros['fim']));
                    } else {
                        echo date('d/m/Y');
                    }  ?>
                </h3>
                <h3><span class="span-data"><?= $config['cfgc_empresa'] ?></span></h3>
                <p>CNPJ: <span class="span-data"><?= $config['cfgc_cnpj'] ?></span> | Telefone: <span class="span-data"><?= mascaraCelular($config['cfgc_fixo']) ?></span> | Celular: <span class="span-data"><?= mascaraCelular($config['cfgc_cel1']) ?></span> </p>
                <p>Endereço: <span class="span-data"> <?= $config['cfgc_endereco'] ?>, <?= $config['cfgc_numero'] ?>, <?= $config['cfgc_bairro'] ?>, <?= $config['cfgc_cidade'] ?>, <?= $config['cfgc_estado'] ?></p>
            </div>

            <div class="col-md-10 form-group text-center" style="border-bottom: 2px solid lightgrey;padding-top: 20px"></div>

        </div>

        <!-- Meio: Informações do Item Selecionado -->


        <div class="row justify-content-center mt-5">
            <div class="col-md-10">
                <div class="row justify-content-between">
                    <div class="col-md-12 col-sm-12">
                        <p>Solicitação: <span class="span-data mr-5"><?= $item['vr_solicitacao_id'] ?></span>
                            Protocolo: <span class="span-data mr-5"><?= $item['vr_protocolo'] ?></span>
                            Validade: <span class="span-data mr-5"><?= date('d/m/Y', strtotime($item['vr_data_validade'])) ?></span>
                            Motorista: <span class="span-data "><?= $item['motorista_nome'] ?></span>
                        </p>
                    </div>

                    <div class="col-md-12 col-sm-12">
                        <p>Fornecedor: <span class="span-data mr-5"><?= $item['fornecedor_nome'] ?></span>
                            Endereço: <span class="span-data"><?= $fornecedor['fornecedor_endereco'] ?>, <?= $fornecedor['fornecedor_numero'] ?>, <?= $fornecedor['fornecedor_bairro'] ?>, <?= $fornecedor['fornecedor_cidade'] ?>, <?= $fornecedor['fornecedor_estado'] ?>, <?= $fornecedor['fornecedor_cep'] ?></span>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabela: Informações dos Itens -->
        <div class="row justify-content-center mt-5">
            <div class="col-md-10 form-group">
                <table class="table table-hover table-bordered inside-table">
                    <thead>
                        <tr style="background-color: #eee;">
                            <th>Descricão</th>
                            <th style="width: 20%">Quantidade</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php echo $item['vr_descricao'] ?></td>
                            <td><?php echo $item['vr_quantidade'] ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>

        </div>


        <div class="row justify-content-center">
            <div class="col-md-6 col-sm-6">
                <div class="signature-line">
                    Assinatura da Transportadora
                </div>
            </div>
            <div class="col-md-6 col-sm-6">
                <div class="signature-line">
                    Assinatura do Motorista
                </div>
            </div>

            <!--<div class="col-md-3 col-sm-3">
                <strong>Válido apenas <?php echo date('d/m/Y') ?></strong>
            </div>-->

            <div class="col-md-12 form-group text-center mt-5 mb-5" style="border-bottom: 2px solid lightgrey;padding-top: 20px"></div>

            <div class="col-md-10 col-sm-10 mb-5">
                <p>Solicitação: <span class="span-data mr-5"><?= $item['vr_solicitacao_id'] ?></span> Protocolo: <span class="span-data"><?= $item['vr_protocolo'] ?></span></p>
                <p>Nome: <span class="span-data mr-5"><?= $item['motorista_nome'] ?></span> Fornecedor: <span class="span-data mr-5"><?= $item['fornecedor_nome'] ?></span>Data: <span class="span-data"><?= date('d/m/Y', strtotime($item['vr_data_hora'])) ?></span></p>

                </p>
            </div>

            <div class="col-md-6 col-sm-6">
                <div class="signature-line">
                    Assinatura do Motorista
                </div>
            </div>
            <div class="col-md-6 col-sm-6">
                <div class="signature-line">
                    Assinatura da Transportadora
                </div>
            </div>

        </div>

        <br><br>
        <!-- Rodapé: Linhas de Assinatura -->
        <footer id="footer" style="position: fixed; bottom: 0; width: 100%;display: none">
            <br><br>
        </footer>

    </div>
</div>

<script>
    function pdf() {
        $('#pdf').css('display', 'none');
        $('#footer').css('display', 'block');
        window.print();
        $('#footer').css('display', 'none');
        $('#pdf').css('display', 'block');
    }
</script>