<?php
function mascaraCelular($numero)
{
    // Remove todos os caracteres que não são números
    $numero = preg_replace('/\D/', '', $numero);

    // Verifica se o número tem 11 dígitos (DDD + número de celular com 9 dígitos)
    if (strlen($numero) == 11) {
        // Formata como (XX) XXXXX-XXXX
        return preg_replace('/(\d{2})(\d{5})(\d{4})/', '($1) $2-$3', $numero);
    }

    if (strlen($numero) == 10) {
        // Formata como (XX) XXXXX-XXXX
        return preg_replace('/(\d{2})(\d{4})(\d{4})/', '($1) $2-$3', $numero);
    }
    // Caso o número não tenha 11 dígitos, retorna o número original
    return $numero;
}

?>
<style>
    .span-data {
        font-weight: bold;
    }

    .td-impar {
        background-color: #eee !important;
    }

    .inside-table {
        width: 100%;
    }

    .inside-table tr {
        font-size: 11px;
    }

    .inside-table tr:hover {
        background-color: #eee !important;
    }

    .inside-table td {
        border: 0;
    }

    .inside-table th {
        border: 0;
        border-bottom: 0px !important;
    }

    .sep-tr {
        border-top: 2px solid lightgrey;
    }

    .title-inside {
        font-weight: bold;
    }

    .signature-line {
        width: 40%;
        border-top: 1px solid #000;
        margin: 20px auto 0 auto;
        text-align: center;
        padding-top: 5px;
    }

    .footer-text {
        font-size: 12px;
    }

    .pdf-icon {
        margin-left: 10px;
        cursor: pointer;
    }

    .container1 {
        border: 2px solid #000;
        max-width: 80% !important;
        margin: 0 auto;
    }

    .border2 {
        border-bottom: 2px solid #000;
    }

    .label {
        font-size: 12px;
        font-weight: 400;
    }

    .retangulo {
        border: 1px solid #000;
        padding: 5px;
        margin: 10px 0;
        height: 30px;
    }

    .retangulofull {
        border: 1px solid #000;
        padding: 10px;
        margin: 10px 0;
    }


    .text_upercase {
        text-transform: uppercase;
    }

    table thead th {
        font-size: 14px
    }

    table tbody tr td {
        font-size: 16px;
        text-transform: uppercase;
    }

    table tfoot tr td {
        font-size: 16px;
        text-transform: uppercase;
    }
</style>


<div class="row">

    <div class="col-md-12 form-group text-center m-2">
        <button onclick="pdf()" id="pdf" class="btn btn-primary" style="float: left">.PDF</button>
    </div>

    <div class="col-md-12 container1 border-dark" id="main">

        <div class="row border2">
            <div class="col-md-4 col-sm-4 form-group text-center">
                <img src="<?php echo base_url('resources/imgs/logotemp.png') ?>" style="width: 95%; height: auto; ">
            </div>
            <div class="col-md-8  col-sm-8 form-group text-center">
                <h3>
                    TOLEDO DO BRASIL
                    <?php
                    date_default_timezone_set('America/Sao_Paulo');
                    if (!empty($filtros['inicio'])) {
                        echo ' de ' . date('d/m/Y', strtotime($filtros['inicio'])) . ' a ' . date('d/m/Y', strtotime($filtros['fim']));
                    } else {
                        echo date('d/m/Y');
                    }  ?>
                </h3>
                <h3><?= $item['cliente_nome'] ?></h3>
                <h3><b class="span-data">Ticket de Pesagem - Documentos</b></h3>
            </div>
        </div>

        <!-- Meio: Informações do Item Selecionado -->


        <div class="row justify-content-center mt-5">
            <div class="col-md-10">
                <div class="row ">
                    <div class="col-md-12 col-sm-12">
                        <p class="title-inside">
                            TICKET DE PESAGEM: <?= $item['tk_ticket_pesagem'] ?>
                            <span class="span-data">
                            </span>
                            <span class="title-inside ml-4">UNIDADE: <?= $item['tk_unidade'] ?></span>
                            <span class="title-inside ml-4">Pesagem Final</span>
                            <span class="title-inside ml-4">Identificador - TAG</span>
                        </p>
                    </div>
                    <div class="col-md-4 col-sm-4">
                        <p class="title-inside">Placa da Carreta</p>
                        <div class="retangulo">
                            <p class="text_upercase"><?= $item['carreta']['placa'] ?></p>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-4">
                        <p class="title-inside">Placa do Veículo</p>
                        <div class="retangulo">
                            <p class="text_upercase"><?= $item['veiculo']['placa'] ?></p>
                        </div>
                    </div>

                    <div class="col-md-8 col-sm-8">
                        <p class="title-inside">Transportadora</p>
                        <div class="retangulo">
                            <p class="text_upercase"><?= $item['tk_transportadora'] ?></p>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-4">
                        <p class="title-inside">Tipo de movimento</p>
                        <div class="retangulo">
                            <p class="text_upercase"><?= $item['tk_tipo_movimento'] ?></p>
                        </div>
                    </div>

                    <div class="col-md-8 col-sm-8">
                        <p class="title-inside">Emissor</p>
                        <div class="retangulo">
                            <p class="text_upercase"><?= $item['cliente_nome'] ?></p>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-4">
                        <p class="title-inside">Doca / Depsosito</p>
                        <div class="retangulo">
                            <p class="text_upercase"><?= $item['tk_deposito'] ?></p>
                        </div>
                    </div>

                    <div class="col-md-8 col-sm-8">
                        <p class="title-inside">Item</p>
                        <div class="retangulo">
                            <p class="text_upercase"><?= $item['produto_nome'] ?></p>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-4">
                        <p class="title-inside">Tipo de veículo</p>
                        <div class="retangulo">
                            <p class="text_upercase"><?= $item['tk_tipo_veiculo'] ?></p>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-4">
                        <p class="title-inside">Pré-Entrada</p>
                        <div class="retangulofull">
                            <p><b>Data/Hora:</b> <?= date('d/m/Y H:i', strtotime($item['tk_pre_data'])) ?></p>
                            <p><b>Operador:</b>
                            <p class="text_upercase"><?= $item['tk_pre_operador'] ?></p>
                            </p>
                            <p><b>Motorista:</b>
                            <p class="text_upercase"><?= $item['tk_pre_motorista'] ?></p>
                            </p>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-4">
                        <p class="title-inside">Pesagem Inicial</p>
                        <div class="retangulofull">
                            <p><b>Data/Hora:</b> <?= date('d/m/Y H:i', strtotime($item['tk_pi_data'])) ?></p>
                            <p><b>Balança:</b>
                            <p class="text_upercase"><?= $item['tk_pi_balanca'] ?></p>
                            </p>
                            <p><b>Peso (kg):</b> <?= $item['tk_pi_peso'] ?></p>
                            <p><b>Operador:</b>
                            <p class="text_upercase"><?= $item['tk_pi_operador'] ?></p>
                            </p>
                            <p><b>Motorista:</b>
                            <p class="text_upercase"><?= $item['tk_pi_motorista'] ?></p>
                            </p>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-4">
                        <p class="title-inside">Pesagem Final</p>
                        <div class="retangulofull">
                            <p><b>Data/Hora:</b> <?= date('d/m/Y H:i', strtotime($item['tk_pf_data'])) ?></p>
                            <p><b>Balança:</b>
                            <p class="text_upercase"><?= $item['tk_pf_balanca'] ?></p>
                            </p>
                            <p><b>Peso (kg):</b> <?= $item['tk_pf_peso'] ?></p>
                            <p><b>Operador:</b>
                            <p class="text_upercase"><?= $item['tk_pf_operador'] ?></p>
                            </p>
                            <p><b>Motorista:</b>
                            <p class="text_upercase"><?= $item['tk_pf_motorista'] ?></p>
                            </p>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-4">

                    </div>

                    <div class="col-md-4 col-sm-4">
                        <p class="title-inside">Diferença de origem</p>
                        <div class="retangulo">
                            <p class="text_upercase"><?= $item['tk_diferenca_origem'] ?></p>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-4">
                        <p class="title-inside">Peso Líquido</p>
                        <div class="retangulo">
                            <p class="text_upercase"><?= $item['tk_peso_liquido'] ?></p>
                        </div>
                    </div>


                </div>
            </div>
        </div>

        <!-- Tabela: Informações dos Itens -->
        <div class="row justify-content-center mt-5">
            <div class="col-md-10 form-group">
                <table class="table table-hover table-bordered inside-table">
                    <thead>
                        <tr style="background-color: #eee;">
                            <th>Documento</th>
                            <th style="width: 25%;">Quantidade a carregar</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="text_upercase"><?php echo $item['tk_solicitacao_id'] ?></td>
                            <td class="text_upercase"><?php echo $item['tk_quantidade_carregar'] ?> kg</td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td class="text-right font-bold">Total de peso origem:</td>
                            <td class="text_upercase"><?php echo $item['tk_quantidade_carregar'] ?> kg</td>
                        </tr>
                    </tfoot>
                </table>

                <p>Observação: <?= $item['tk_observacao'] ?> </p>

            </div>
        </div>


        <br><br>
        <div class="row justify-content-center mt-5 " style="border-top: 2px solid #000;">

            <div class="col-md-12 col-sm-12">
                <p class="m-2 title-inside">
                    Nº ticket: <span class="text_upercase font-light mr-5"><?= $item['tk_ticket_pesagem'] ?></span>
                    Nº DT: <span class="text_upercase font-light mr-5">651651616156165</span>
                    Placa veículo: <span class="text_upercase font-light mr-5"><?= $item['veiculo']['placa'] ?></span>
                    Placa carreta: <span class="text_upercase font-light mr-5"><?= $item['carreta']['placa'] ?></span><br />
                    Produto: <span class="text_upercase font-light mr-5"><?= $item['produto_nome'] ?></span>
                    Data/hora: <span class="text_upercase font-light mr-5"><?= date('d/m/Y', strtotime($item['tk_data'])) ?></span>
                    Peso Líquido (kg): <span class="font-light mr-5"><?= $item['tk_peso_liquido'] ?></span>

                </p>
            </div>

            <div class="col-md-6 col-sm-6 mt-5">
                <div class="signature-line">
                    Nome da Empresa - Assinatura
                </div>
            </div>
            <div class="col-md-6 col-sm-6 mt-5">
                <div class="signature-line">
                    Motorista - Assinatura
                </div>
            </div>
        </div>

        <br><br>
        <!-- Rodapé: Linhas de Assinatura -->
        <footer id="footer" style="position: fixed; bottom: 0; text-align: center; width: 100%;display: none">
            <br><br>
            <div class="row justify-content-center">
                <div class="col-md-5 col-sm-6 text-left footer-text">
                    <p><b>Relatório Gerado em <?php echo date('d/m/Y - H:i:s') ?></b></p>
                </div>
                <div class="col-md-5 col-sm-6 mb-5 footer-text">
                    <p>N Soluções</p>
                </div>
            </div>
        </footer>

    </div>
</div>

<script>
    function pdf() {
        $('#pdf').css('display', 'none');
        $('#footer').css('display', 'block');
        window.print();
        $('#footer').css('display', 'none');
        $('#pdf').css('display', 'block');
    }
</script>