            <head>
                <link href="https://cdn.datatables.net/v/dt/jszip-3.10.1/dt-2.1.8/b-3.1.2/b-html5-3.1.2/r-3.0.3/datatables.min.css" rel="stylesheet">
            </head>

            <style>
                .tableFixHead {
                    overflow-y: auto;
                    height: 450px;
                }

                .tableFixHead thead th {
                    position: sticky;
                    top: 0;
                }

                /* Just common table stuff. Really. */
                table {
                    border-collapse: collapse;
                    width: 100%;
                }

                .table th {
                    font-size: 11px;
                }

                th,
                td {
                    padding: 8px 16px;
                }

                th {
                    background: #eee;
                }

                #text-permissao th {
                    background: white;
                }

                .main-row {
                    padding-left: 10px;
                    padding-right: 10px;
                }

                .main-col-12 {
                    padding: 20px;
                    background-color: white;
                    border-radius: 5px;
                }

                .dataTables_wrapper .row {
                    width: 101%;
                    margin-bottom: 15px;
                }

                .pagination {
                    margin-top: 0px;
                }

                .dataTables_length label select {
                    margin-left: 10px;
                    margin-right: 10px;
                }

                .row-c {
                    width: 110%;
                    margin-bottom: 15px;
                }

                .btn-primary {
                    background-color: #033557;
                    border-color: #033557;
                }

                .btn-primary:hover {
                    background-color: #033557;
                    border-color: #033557;
                }

                .btn-primary:focus {
                    background-color: #033557;
                    border-color: #033557;
                }

                .btn-primary:not(:disabled):not(.disabled).active,
                .btn-primary:not(:disabled):not(.disabled):active,
                .show>.btn-primary.dropdown-toggle {
                    background-color: #033557;
                    border-color: #033557;
                }

                .pagination>.active>a {
                    background-color: #033557;
                }

                .pagination>.active>a:hover {
                    background-color: #033557;
                }

                .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
                    background: white;
                    border-color: white;
                }

                .btn-info-red {
                    float: right;
                    margin-right: 15px;
                    width: 25px;
                    height: 25px;
                    border: 2px solid black;
                    border-radius: 50%;
                    text-align: center;
                    color: red;
                    cursor: pointer;
                }

                .btn-info-red:hover {
                    color: black;
                }

                .swal2-title {
                    font-size: 25px;
                }

                .swal2-content {
                    font-size: 20px;
                }

                .swal2-styled.swal2-confirm {
                    font-size: 15px;
                }

                @media (min-width: 500px) {
                    .swal2-popup.swal2-modal.swal2-icon-info.swal2-show {
                        width: 40%;
                    }
                }

                .see-pass {
                    width: 10%;
                    margin-left: -4px;
                    margin-top: -2px;
                    border-top-left-radius: 0;
                    border-bottom-left-radius: 0;
                }

                .passwd {
                    width: 50%;
                    display: inline;
                    border-top-right-radius: 0;
                    border-bottom-right-radius: 0;
                }

                .encurtar {
                    display: -webkit-box;
                    overflow: hidden;
                    -webkit-line-clamp: 1;
                    -webkit-box-orient: vertical;
                    word-break: break-word;
                    line-height: 11px !important;
                }

                .hidden {
                    display: none;
                }

                .modalCard {
                    width: 100%;
                    height: 100%;
                    overflow-y: hidden;
                    padding: 20px;
                    border-radius: 5px;
                    background-color: #00000073;
                    overflow-x: hidden;
                    position: absolute;
                    top: 0;
                    left: 0;
                    z-index: 99;
                    display: none;
                }
            </style>

            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="container-fluid">

                <div class="row main-row">
                    <div class="col-md-12 main-col-12">

                        <div class="row main-row">
                            <?php /*if($this->session->userdata('editar') == 1 ){*/ ?>
                            <div style="margin-bottom: 10px">
                                <a class="btn btn-primary" style='color: white' onclick="newForm(true)" data-toggle="modal" data-target="#modalItem">Novo</a>
                            </div>

                            <div id="btn-pdf">
                                &nbsp;&nbsp;<a class="btn btn-primary" data-toggle="modal" data-target="#modalFiltro"><em class="fa fa-file-o"></em>&nbsp;&nbsp;PDF</a>

                            </div>
                            <div>
                                &nbsp;&nbsp;<a class="btn btn-primary" id="btn-excel_old" data-toggle="modal" data-target="#modalFiltroEXCEL"><em class="fa fa-file-o"></em>&nbsp;&nbsp;EXCEL</a>
                            </div>
                        </div>
                        <?php /*}*/ ?>
                        <?php if ($erro != null) { ?>
                            <div class="row" style="margin-bottom: 20px">
                                <div class="col-md-12">
                                    <h3 class="text-danger">Erro: A senha informada estava incorreta, por favor tente novamente!</h3>
                                </div>
                            </div>
                        <?php } ?>

                        <div class="input-group-append" style="position: absolute; right: 22px; height: 30px;top:75px; z-index: 2;">
                            <span style="background: white; border: 1px solid lightgrey" class="input-group-text" id="basic-addon2"><i style="font-size: 18px; cursor: pointer; color: #033557!important;" class="fa fa-search" aria-hidden="true"></i></span>
                        </div>

                        <div class="tableFixHead" style="height: auto;">
                            <table id="myTableFunc" class="table table-hover table-bordered">
                                <thead>
                                    <tr>
                                        <th style="width: 3%">Solicitação</th>
                                        <th style="width: 8%">Data hora</th>
                                        <!--<th style="width: 16%">Fornecedor</th>-->
                                        <th style="width: 7%">Placa</th>
                                        <th style="width: 13%">Motorista</th>
                                        <th style="width: 3%">Litros</th>
                                        <th style="width: 3%">Combustível</th>
                                        <th style="width: 9%">Valor</th>
                                        <th style="width: 1%;">Quitada</th>
                                        <th style="width: 16%">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($itens as $itm) { ?>
                                        <tr>
                                            <td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo ucwords('AB' . str_pad($itm['abst_solicitacao_abastecimento_id'], 6, '0', STR_PAD_LEFT)); ?>">
                                                    <?php echo ucwords(str_pad($itm['abst_solicitacao_abastecimento_id'], 6, '0', STR_PAD_LEFT)) ?>
                                                </div>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <?php echo date('d/m/Y H:i', strtotime($itm['abst_data_hora'])) ?>
                                            </td>
                                            <!--<td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo ucwords(mb_strtolower($itm['fornecedor_nome'])); ?>">
                                                    <?php echo ucwords(strtolower($itm['fornecedor_nome'])) ?>
                                                </div>
                                            </td>-->
                                            <td style="vertical-align: middle;">
                                                <div title="<?php echo ucwords(strtoupper($itm['veiculo']['nome'])); ?>">
                                                    <?php echo strtoupper($itm['veiculo']['placa']) ?>
                                                </div>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <div class="encurtar" title="<?php echo ucwords(mb_strtolower($itm['motorista_nome'])); ?>">
                                                    <?php echo ucwords(strtolower($itm['motorista_nome'])) ?>
                                                </div>
                                            </td>
                                            <td style="vertical-align: middle;">
                                                <?php echo $itm['abst_quantidade_litros']; ?> </td>
                                            <td style="vertical-align: middle;">
                                                <?php echo $itm['abst_combustivel']; ?> </td>
                                            <td style="vertical-align: middle;">
                                                R$ <?php echo number_format($itm['abst_valor'], 2, ',', '.') ?> </td>
                                            <td style="vertical-align: middle;">
                                                <?php echo $itm['abst_quitada']; ?> </td>
                                            <td style="vertical-align: middle;">
                                                <a style="font-size: 10px;padding: 5px 10px" onclick='openItem(JSON.stringify(<?php echo json_encode($itm) ?>), false, false,false)' class="btn btn-primary btn-modal-toggle mb-1"><i class="fas fa-eye"></i></a>
                                                <a style="font-size: 10px;padding: 5px 10px" href="<?php echo base_url('relatoriosingleabastecimento/' . $itm['abst_id']) ?>" target="_blank" class="btn btn-primary btn-modal-toggle mb-1"><i class="fa fa-file-o m-1"></i> </a>
                                                <a style="font-size: 10px;padding: 5px 10px" <?php echo $itm['abst_quitada'] === "Sim" ? 'disabled' : '' ?> onclick='openItem(JSON.stringify(<?php echo json_encode($itm) ?>), true, <?php echo $itm["abst_quitada"] === "Sim" ? "true" : "false" ?>,false)' class="btn btn-primary mb-1"><i class="fas fa-pencil-alt"></i></a>
                                                <?php /*if ($this->session->userdata('excluir') == 1) {*/ ?>
                                                <a data-toggle="modal" data-target="#modalExcluir" <?php echo $itm['abst_quitada'] === "Sim" ? 'style="display: none"' : '' ?> class="btn btn-danger" style="font-size: 10px;padding: 5px 10px" onclick="setaExcluir('<?php echo $itm['abst_id']; ?>')"><i class="fas fa-trash"></i></i></a>
                                                <?php //} 
                                                ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>

            </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->
            <div class="modal fade" id="modalItem" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header" style="text-align: left; justify-content: unset;">
                            <h5 class="modal-title" id="exampleModalLongTitle">Lançamento</h5>
                        </div>
                        <form action="<?php echo base_url('abastecimento/novoitem'); ?>" method="post" enctype='multipart/form-data'>
                            <div class="modal-body">
                                <h4>Abastecimento</h4>
                                <div class="row">
                                    <input class="inputItem" type="hidden" id="abst_id" name="abst_id">
                                    <div class="col-md-6 form-group">
                                        <label for="abst_fornecedor_cnpj" class="form-label">Fornecedor</label>
                                        <select required class="form-control inputItem select2-input" id="abst_fornecedor_cnpj" name="abst_fornecedor_cnpj" style="width:100%;">
                                            <option value="" selected disabled>-- Selecionar --</option>
                                            <?php foreach ($fornecedores as $forn) { ?>
                                                <option value="<?php echo $forn['fornecedor_cnpj']; ?>"> <?php echo $forn['fornecedor_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="abst_veiculo_id" class="form-label">Veículo</label>
                                        <select class="form-control inputItem select2-input" style="width:100%;" id="abst_veiculo_id" name="abst_veiculo_id" required>
                                            <option value="" selected disabled>-- Selecionar --</option>
                                            <?php foreach ($veiculos as $veic) { ?>
                                                <option value="<?php echo $veic['id']; ?>"> <?php echo $veic['nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="abst_motorista_id" class="form-label">Motorista</label>
                                        <select required class="form-control inputItem select2-input" style="width:100%;" id="abst_motorista_id" name="abst_motorista_id" placeholder="buscar por nome, cpf, telefone">
                                            <option value="" selected disabled>-- Selecionar --</option>
                                            <?php foreach ($motoristas as $moto) { ?>
                                                <option value="<?php echo $moto['motorista_id']; ?>"> <?php echo $moto['motorista_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="abst_protocolo">Protocolo</label>
                                        <input class="form-control inputItem" name="abst_protocolo" id="abst_protocolo">
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="abst_quantidade_litros">Quantidade de litros</label>
                                        <input required class="form-control inputItem" name="abst_quantidade_litros" id="abst_quantidade_litros">
                                    </div>

                                    <!--<div class="col-md-6 form-group">
                                        <label for="abst_valor">Valor</label>
                                        <div class="form-control body_value">
                                            <div class="row">
                                                <label class="col-md-2">R$</label>
                                                <input required class=" col-md-9 inputItem" style="border-width:0" name="abst_valor" id="abst_valor">
                                            </div>
                                        </div>
                                    </div>-->

                                    <div class="col-md-6 form-group">
                                        <label for="abst_valor">Valor (R$)</label>
                                        <input required class="form-control inputItem valor" name="abst_valor" id="abst_valor">
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label>Combustível</label><br>
                                        <select required class="form-control inputItem" id="abst_combustivel" name="abst_combustivel" style="width: 100%!important">
                                            <option value="" selected disabled>-- Selecione --</option>
                                            <option value="Gasolina">Gasolina</option>
                                            <option value="Álcool">Etanol</option>
                                            <option value="Diesel">Diesel</option>
                                            <option value="GNV">GNV</option>
                                            <option value="Biodiesel">Biodiesel</option>
                                            <option value="15W 40">Oleo de Motor 15W 40</option>
                                            <option value="Hidraulico">Oleo Hidraulico</option>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label id="importancia">Criado em</label>
                                        <input required class="form-control inputItem" name="abst_data_hora" id="abst_data_hora" type="datetime-local">
                                    </div>

                                    <!-- anexo -->
                                    <div class="col-md-8 mb-5">
                                        <div id="no-file" style="display: none"><br />Não tem anexo</div>
                                        <div class="input-group" id="inputImageFile">
                                            <div class="row" style="margin: 0">
                                                <label class="preset-docs-docs-doc-title" style="float:left;">Anexo</label>
                                            </div>
                                            <div class="row" style="margin: 0">
                                                <input
                                                    type="text" class="form-control"
                                                    placeholder="Selecione um arquivo" id="5-file"
                                                    value="<?php if (isset($_GET['edicao_id'])) {
                                                            } ?>" disabled style="width: 100%" />
                                                <div class="input-group-append" style="width: 100%">
                                                    <input
                                                        id="5-doc" type="file" name="5-doc" class="file"
                                                        accept=".jpg, .jpeg, .png" style="display:none;"
                                                        onchange="triggerInputFile(this.id, event)" />
                                                    <button id="5-search" type="button" class="browse btn btn-primary" style="width:100%">Buscar...</button>
                                                </div>
                                            </div>

                                            <small class="preset-docs-docs-doc-title mt-2 mb-2 text-muted" style="float:left;">Formatos permitidos: .jpg, .jpeg, .png</small>

                                        </div>
                                        <div class="row" style="margin: 0;display:none;" id="body-btn-img">
                                            <div class="col-md-10" style="margin:0;margin-top: 25px;width: 80%">
                                                <a href="/uploads/" target="_blank" id="btn-img" class="btn btn-primary" style="width: 100%;margin:0;">Clique para ver a imagem</a>
                                            </div>
                                            <div class="col-md-2" style="width:20%;font-size: 12px;margin-top: 25px;margin-left: 10px">
                                                <a class="btn btn-danger" style="font-size: 12px" onclick="onDeleteAnexo('<?php echo $itm['tk_id']; ?>',1)"><i class="fas fa-trash"></i></i></a>
                                            </div>
                                        </div>
                                        <!--<img id="5-preview" class="img-thumbnail" style="max-width:200px; height:auto;" />-->
                                    </div>
                                    <!-- anexo -->

                                </div>
                                <div class="modal-footer" id="modal-footer-btn" style="position: relative">
                                    <button class="btn btn-danger" data-dismiss="modal" onclick="closemodal()" type="button">Cancelar</button>
                                    <button class="btn btn-primary" id="btn-salvar" type="submit">Salvar</button>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
            </div>

            <div class="modal fade" id="modalFiltro" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">

                        <div class="modal-header">
                            <div class="row row-c">
                                <div class="col-md-10">
                                    <h4 class="modal-title">Filtros</h4>
                                </div>
                                <div class="col-md-2 text-right">
                                    <button type="button" class="close" onclick="hideFiltro()" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <form action="<?php echo base_url('relatorioabastecimento') ?>" method="post" target="_blank">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-6 form-group">
                                        <label id="importancia">Data inicial</label>
                                        <input class="form-control" onchange='dateIsOlder("inicio", "fim")' id="inicio" name="inicio" type="date">
                                    </div>
                                    <div class="col-md-6 form-group">
                                        <label id="importancia">Data final</label>
                                        <input class="form-control" onchange='dateIsOlder("inicio", "fim")' id="fim" name="fim" type="date">
                                    </div>
                                    <div class="col-md-4 form-group">
                                        <label>Quitada</label><br>
                                        <select style="width: 100%!important" class=" form-control select2-filtro" name="quitada">
                                            <option value="todas" selected>-- Todas --</option>
                                            <option value="Sim">-- Sim --</option>
                                            <option value="Não">-- Não --</option>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="motorista_id" class="form-label">Motorista</label>
                                        <select required class="form-control select2-input_filtros" style="width:100%;" name="motorista_id" placeholder="buscar por nome, cpf, telefone">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($motoristas as $moto) { ?>
                                                <option value="<?php echo $moto['motorista_id']; ?>"> <?php echo $moto['motorista_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="fornecedor_cnpj" class="form-label">Fornecedor</label>
                                        <select required class="form-control select2-input_filtros" style="width:100%;" name="fornecedor_cnpj">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($fornecedores as $forn) { ?>
                                                <option value="<?php echo $forn['fornecedor_cnpj']; ?>"> <?php echo $forn['fornecedor_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger" onclick="hideFiltro()">Cancelar</button>
                                &nbsp;&nbsp;
                                <button type="submit" class="btn btn-primary">Gerar PDF</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <div class="modal fade" id="modalFiltroEXCEL" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">

                        <div class="modal-header">
                            <div class="row row-c">
                                <div class="col-md-10">
                                    <h4 class="modal-title">Filtros</h4>
                                </div>
                                <div class="col-md-2 text-right">
                                    <button type="button" class="close" onclick="hideFiltro()" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <form action="<?php echo base_url('relatorioexcelabastecimento') ?>" method="post" target="_blank">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-4 form-group">
                                        <label id="importancia">Data inicial</label>
                                        <input class="form-control" onchange='dateIsOlder("inicio", "fim")' id="inicio" name="inicio" type="date">
                                    </div>
                                    <div class="col-md-4 form-group">
                                        <label id="importancia">Data final</label>
                                        <input class="form-control" onchange='dateIsOlder("inicio", "fim")' id="fim" name="fim" type="date">
                                    </div>
                                    <div class="col-md-4 form-group">
                                        <label>Quitada</label><br>
                                        <select style="width: 100%!important" class=" form-control select2-filtro" name="quitada">
                                            <option selected value="todas">-- Todas --</option>
                                            <option value="Sim">-- Sim --</option>
                                            <option value="Não">-- Não --</option>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="motorista_id" class="form-label">Motorista</label>
                                        <select class="form-control select2-input_filtrosE" style="width:100%;" name="motorista_id">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($motoristas as $moto) { ?>
                                                <option value="<?php echo $moto['motorista_id']; ?>"> <?php echo $moto['motorista_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 form-group">
                                        <label for="fornecedor_cnpj" class="form-label">Fornecedor</label>
                                        <select class="form-control select2-input_filtrosE" style="width:100%;" name="fornecedor_cnpj">
                                            <option value="todas" selected>-- Todos --</option>
                                            <?php foreach ($fornecedores as $forn) { ?>
                                                <option value="<?php echo $forn['fornecedor_cnpj']; ?>"> <?php echo $forn['fornecedor_nome']; ?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger" onclick="hideFiltro()">Cancelar</button>
                                &nbsp;&nbsp;
                                <button type="submit" class="btn btn-primary">Gerar EXCEL</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <div class="modal fade" id="modalExcluir" tabindex="-1" role="dialog" aria-labelledby="modalExcluirTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <form action="<?php echo base_url('abastecimento/deletar') ?>" method="post">
                        <input type="hidden" name="abst_id" id="abst_id_delete">
                        <div class="modal-content">
                            <div class="modal-header" style="text-align: left; justify-content: unset;">
                                <h5 class="modal-title" id="exampleModalLongTitle">Mensagem do Sistema</h5>
                            </div>
                            <div class="modal-body">
                                <h4>Deseja realmente excluir este item?</h4>
                            </div>
                            <div class="modal-footer" style="position: relative">
                                <button class="btn btn-primary" style="position: absolute; top: 15px; left: 15px; color: white; float: left" onclick="senha()">&nbsp&nbspSim&nbsp&nbsp</button>
                                <button class="btn btn-danger" data-dismiss="modal">&nbsp&nbspNão&nbsp&nbsp</button>
                                <br><br>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="modal fade" id="modalExcluirAnexo" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <input type="hidden" name="id_anexo" id="id_anexo">
                    <input type="hidden" name="id_index" id="id_index">
                    <div class="modal-content">
                        <div class="modal-header" style="text-align: left; justify-content: unset;">
                            <h5 class="modal-title" id="exampleModalLongTitle">Mensagem do Sistema</h5>
                        </div>
                        <div class="modal-body">
                            <h4>Deseja realmente excluir este anexo?</h4>
                        </div>
                        <div class="modal-footer" style="position: relative">
                            <button class="btn btn-primary" style="position: absolute; top: 15px; left: 15px; color: white; float: left" onclick="deleteAnexo()">&nbsp&nbspSim&nbsp&nbsp</button>
                            <button class="btn btn-danger" data-dismiss="modal">&nbsp&nbspNão&nbsp&nbsp</button>
                            <br><br>
                        </div>
                    </div>
                </div>
            </div>

            <script>
                $(document).on("click", ".browse", function() {
                    var id = this.id;
                    id = id.replaceAll("-search", "");
                    var file = $(this).parents().find("#" + id + "-doc");
                    file.prop("disabled", false);
                    file.trigger("click");
                });

                $('input[type="file"]').change(function(e) {
                    var fileID = this.id;
                    fileID = fileID.replaceAll("-doc", "");
                    var fileName = e.target.files[0].name;
                    $("#" + fileID + "-file").val(fileName);

                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (e.target.result.includes('data:image/')) {
                            document.getElementById(fileID + "-preview").src = e.target.result;
                        } else {
                            document.getElementById(fileID + "-preview").src = '<?php echo base_url('resources/imgs/pdf_cover.png') ?>';
                        }
                    };
                    reader.readAsDataURL(this.files[0]);
                });

                function triggerInputFile(id, e) {
                    var fileID = id;
                    fileID = fileID.replaceAll("-doc", "");
                    var fileName = e.target.files[0].name;
                    $("#" + fileID + "-file").val(fileName);

                    var reader = new FileReader();
                    reader.onload = function(e) {
                        document.getElementById(fileID + "-preview").src = e.target.result;
                    };
                    reader.readAsDataURL(e.target.files[0]);
                }
            </script>

            <script>
                /*$('.select2').select2({
                        theme: "bootstrap",
                        placeholder: 'Busque por placa, nome ou marca',
                        minimumInputLength: 0, // Começa a busca após 2 caracteres
                        ajax: {
                            url: '/api/search-items', // URL da API para buscar os itens
                            dataType: 'json',
                            delay: 250,
                            data: function(params) {
                                return {
                                    query: params.term // O termo de busca inserido pelo usuário
                                };
                            },
                            processResults: function(data) {
                                // Formata os resultados para o Select2
                                return {
                                    results: data.items.map(function(item) {
                                        return {
                                            id: item.id, // ID do item
                                            text: `${item.placa} - ${item.nome} - ${item.marca}` // O que será exibido no dropdown
                                        };
                                    })
                                };
                            },
                            cache: true
                        }
                    });*/

                function dateIsOlder(input1, input2) {
                    const inicio = new Date($('#' + input1).val());
                    const fim = new Date($('#' + input2).val());
                    if (fim < inicio) {
                        alert('A data final deve ser maior que a inicial');
                        $('#' + input1).val('');
                        $('#' + input2).val('');
                    }
                }

                function newForm(openFoter) {

                    //$('.modalCard').css('display', 'block');
                    $('.body_value').css('background-color', 'white');
                    $('#no-file').css('display', 'none');

                    $('#abst_fornecedor_cnpj').val('');
                    $('#abst_motorista_id').val('');
                    $('#abst_veiculo_id').val('');

                    $('#abst_fornecedor_cnpj').trigger('change');
                    $('#abst_motorista_id').trigger('change');
                    $('#abst_veiculo_id').trigger('change');

                    if (openFoter) {
                        document.getElementById('btn-salvar').style.display = 'block';
                    }
                    const inputs = document.querySelectorAll('.inputItem');
                    inputs.forEach(input => {
                        input.value = '';
                    });
                    toggleInputs(true)

                    document.getElementById('body-btn-img').style.display = 'none';
                    document.getElementById('inputImageFile').style.display = 'block';
                    document.getElementById('abst_data_hora').value = "<?php echo date('Y-m-d H:i'); ?>";

                }

                function toggleInputs(status) {
                    const inputs = document.querySelectorAll('.inputItem');
                    inputs.forEach(input => {
                        if (status) {
                            input.disabled = false;
                        } else {
                            input.disabled = true;
                        }
                    });

                    if (!status) {
                        $('.body_value').css('background-color', '#eee');
                    } else {
                        $('.body_value').css('background-color', 'white');
                    }
                }

                function openItem(item, edit, disabled) {

                    if (disabled) {
                        return
                    }
                    if (!edit) {
                        document.getElementById('btn-salvar').style.display = 'none';
                    } else {
                        document.getElementById('btn-salvar').style.display = 'block';
                    }

                    newForm()

                    $('#modalItem').modal('show');

                    toggleInputs(edit);

                    setTimeout(() => {
                        const values = JSON.parse(item);
                        $('#abst_id').val(values?.abst_id);
                        $('#abst_data_hora').val(values?.abst_data_hora);
                        $('#abst_veiculo_id').val(values?.abst_veiculo_id);
                        $('#abst_combustivel').val(values?.abst_combustivel);
                        $('#abst_quantidade_litros').val(values?.abst_quantidade_litros);
                        $('#abst_protocolo').val(values?.abst_protocolo);

                        console.log('values?.abst_anexo_abastecimento', values?.abst_anexo_abastecimento);
                        if (values?.abst_anexo_abastecimento != null) {
                            document.getElementById('btn-img').href = '/uploads/' + values?.abst_anexo_abastecimento;
                            $('#body-btn-img').css('display', 'block');
                            $('#inputImageFile').css('display', 'none');
                            $('#no-file').css('display', 'none');
                        }else {
                            $('#body-btn-img').css('display', 'none');
                            $('#inputImageFile').css('display', 'none');
                            $('#no-file').css('display', 'block');
                        }

                        if (edit && values?.abst_anexo_abastecimento != null) {
                            $('#body-btn-img').css('display', 'block');
                            $('#inputImageFile').css('display', 'none');
                            $('#no-file').css('display', 'none');
                        } else if (edit && values?.abst_anexo_abastecimento == null) {
                            $('#body-btn-img').css('display', 'none');
                            $('#inputImageFile').css('display', 'block');
                            $('#no-file').css('display', 'none');
                        }

                        $('#abst_veiculo_id').val(values?.abst_veiculo_id).trigger('change');
                        $('#abst_motorista_id').val(values?.abst_motorista_id).trigger('change');
                        $('#abst_fornecedor_cnpj').val(values?.abst_fornecedor_cnpj).trigger('change');

                        const valor = document.getElementById('abst_valor')
                        valor.value = values?.abst_valor
                        valor.dispatchEvent(new Event('input'));

                    }, 500);

                }

                function closemodal() {
                    //$('.modalCard').css('display', 'none');
                }
            </script>


            <script>
                $(document).ready(function() {

                    $('.select2-input').select2({
                        theme: "bootstrap",
                        dropdownParent: $('#modalItem')
                    })

                    $('.select2-input_filtros').select2({
                        theme: "bootstrap",
                        dropdownParent: $('#modalFiltro')
                    })

                    $('.select2-input_filtrosE').select2({
                        theme: "bootstrap",
                        dropdownParent: $('#modalFiltroEXCEL')
                    })

                    $('.js-example-basic-single').select2();

                    $('#abst_valor').mask('000000000000000.00', {
                        reverse: true
                    });
                    /*$('.selectcadastroitem-filtro').select2({
                        theme: "bootstrap",
                        dropdownParent: $('#modalItem')
                    });*/


                    $('#myTableFunc').DataTable({
                        layout: {
                            topStart: 'buttons',
                        },
                        "order": [
                            [0, "desc"]
                        ],
                        "buttons": [{
                            extend: 'excelHtml5',
                            text: 'EXCEL',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7, 8] // Define quais colunas exportar (a coluna de índice 3 será omitida)
                            }
                        }],
                        "language": {
                            "lengthMenu": "Mostrando _MENU_",
                            "zeroRecords": "Nada encontrado- refaça sua busca",
                            "info": "Mostrando _PAGE_ de _PAGES_",
                            "infoEmpty": "Sem registros disponíves",
                            "infoFiltered": "(filtrado _MAX_ dos registros totais)",
                            "sSearch": "Procurar:",
                            "searchPlaceholder": "Digite sua busca",
                            "paginate": {
                                "previous": "Anterior",
                                "next": "Próximo",
                            }
                        },
                        "columns": [{
                                "Data hora": "first",
                                "orderable": true
                            },
                            /*{
                                "Fornecedor": "first",
                                "orderable": true
                            },*/
                            {
                                "Solicitação": "first",
                                "orderable": true
                            },
                            {
                                "Placa": "second",
                                "orderable": true
                            },
                            {
                                "Motorista": "third",
                                "orderable": true
                            },
                            {
                                "Quantidade litro": "fourth",
                                "orderable": true
                            },
                            {
                                "Combustível": "fifth",
                                "orderable": true
                            },
                            {
                                "Valor": "fifth",
                                "orderable": true
                            },
                            {
                                "Quitada": "fifth",
                                "orderable": true
                            },
                            {
                                "Ação": "sixth",
                                "orderable": false
                            },
                        ],
                    })

                    //$('.buttons-excel').removeClass('dt-button buttons-excel buttons-html5').addClass('btn btn-primary');
                    $('.buttons-excel').addClass('hidden');
                    $('#btn-excel').on('click', function() {
                        $('.buttons-excel').click();
                    })
                });
            </script>

            <script>
                function onDeleteAnexo(id, index) {
                    $('#modalExcluirAnexo').modal('show');
                    $('#id_anexo').val(id);
                    $('#id_index').val(index);
                }

                function deleteAnexo() {
                    var form = new FormData();

                    form.append('id', $('#abst_id').val());
                    form.append('index', $('#id_index').val());

                    $.ajax({
                        type: "post",
                        url: "/abastecimento/deleteAnexo",
                        data: form,
                        processData: false, // Evita que o jQuery processe os dados
                        contentType: false,
                        success: function(data) {
                            if ($('#id_index').val() == 1) {
                                document.getElementById('btn-img').href = '';
                                document.getElementById('body-btn-img').style.display = 'none';
                                document.getElementById('inputImageFile').style.display = 'block';
                            }

                            if ($('#id_index').val() == 2) {
                                document.getElementById('2btn-img').href = '';
                                document.getElementById('2body-btn-img').style.display = 'none';
                                document.getElementById('2inputImageFile').style.display = 'block';
                            }

                            $('#modalExcluirAnexo').modal('hide');
                        },
                        error: function(data) {
                            console.log('error', {
                                data
                            });
                        }
                    })


                }

                function setaExcluir(id) {
                    document.getElementById('abst_id_delete').value = id;
                }

                function hideFiltro() {
                    //$('#filtro_marca').val('').change();
                    $('#modalFiltro').modal('hide');
                    $('#modalFiltroEXCEL').modal('hide');
                }
                $('#modalFiltro').on('hidden.bs.modal', function() {
                    hideFiltro();
                });
            </script>