<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Checklistmodel extends CI_Model{

    public function addCategoria($dados){
        $this->db->insert('categorias', $dados);
    }

    public function addItem($dados){
        $this->db->insert('itens', $dados);
    }
    
    public function getCategorias(){
        return $this->db->get('categorias')->result_array();
    }
    
    public function getCategoriaNameById($id){
        $this->db->where('categoria_id', $id);
        $aux = $this->db->get('categorias')->row_array();
        return $aux['categoria_nome'];
    }
    
    public function getItens(){
        $this->db->order_by('item_categoria_id', 'ASC');
        return $this->db->get('itens')->result_array();
    }
    
    public function get($id){
        $this->db->where('item_categoria_id', $id);
        return $this->db->get('itens')->result_array();
    }
    
    public function getItensById($id){
        $this->db->where('item_id', $id);
        return $this->db->get('itens')->row_array();
    }
    
    public function updateItens($item){
        $this->db->replace('itens', $item);
    }
    
    public function getCategoriasById($id){
        $this->db->where('categoria_id', $id);
        return $this->db->get('categorias')->row_array();
        
    }
    
    public function getClientes(){
        return $this->db->get('clientes')->result_array();
    }
    
    public function getChave($chave){
        $this->db->where('checklist_finalizada', 1);
        $this->db->where('checklist_chave', $chave);
        return $this->db->get('checklist')->row_array();
    }
    
    public function getfrota(){
        return $this->db->get('frota')->result_array();
    }
    
    public function getfrotaById($id){
        $this->db->where('frota_id', $id);
        return $this->db->get('frota')->row_array();
    }
    
    public function addChecklist($dados){
        $this->db->insert('checklist', $dados);
    }
    
    public function getChecklistsAtivo(){
        $this->db->where('checklist_finalizada', 0);
        return $this->db->get('checklist')->result_array();
    }
    
    public function getChecklistsByKey($chave){
        $this->db->where('checklist_chave', $chave);
        return $this->db->get('checklist')->row_array();
    }
    
    public function updateCheckList($dados){
        $this->db->replace('checklist', $dados);
    }
    
    public function retriveActiveKey($key){
        $this->db->where('checklist_chave', $key);
        $this->db->where('checklist_finalizada', 0);
        return $this->db->get('checklist')->row_array();
    }
    
    public function removeitem($key){
        $this->db->where('item_id', $key);
        $this->db->delete('itens');
    }
    
    public function getChecklistsCompleto(){
        $this->db->where('checklist_finalizada', 1);
        return $this->db->get('checklist')->result_array();
    }
    
    public function checklistCompleto($id){
        $this->db->where('checklist_id', $id);
        $a = $this->db->get('checklist')->row_array();
        
        $elm = explode("|", $a['checklist_elementos']);
        $ckd = explode("|", $a['checklist_checados']);
        $obs = explode("|", $a['checklist_observacoes']);
        $pic = explode("|", $a['checklist_fotos']);
        
        for($i=0; $i<count($elm); $i++){
            $this->db->where('item_id', $elm[$i]);
            $elm[$i] = $this->db->get('itens')->row_array();
        }
        
        $this->db->select('categoria_id, categoria_nome');
        $c = $this->db->get('categorias')->result_array();
        
        $dados = array(
            'local'         => $a['checklist_local'],
            'data'          => $a['checklist_data'],
            'placa'         => $a['checklist_placa'],
            'hodômetro'     => $a['checklist_hodometro'],
            'chave'         => $a['checklist_chave'],
            'responsavel'   => $a['checklist_responsavel'],
            'categorias'    => $c,
            'itens'         => $elm,
            'checados'      => $ckd,
            'observacoes'   => $obs,
            'fotos'         => $pic,
            );
        return $dados;
    }
    
    
    public function categorias(){
        $this->db->order_by('categoria_posicao', 'ASC');
        $a = $this->db->get('categorias')->result_array();
        for($i=0; $i<count($a); $i++){
            $a[$i]['categoria_nome_limpo'] = str_replace(' ', '', strtolower($a[$i]['categoria_nome']));
        }
        return $a;
    }
    
    public function frota(){
        $this->db->select('frota_id, frota_codigo, frota_placa');
        $a = $this->db->get('frota')->result_array();    
        return $a;
    }
    
    public function cliente(){
        $this->db->select('cliente_cpfcnpj, cliente_nome');
        $a = $this->db->get('clientes')->result_array();    
        return $a;
    }
    
    public function step1($dados){
        $a = array(
            'ckl_frota_id'      => $dados['frota'],
            'ckl_local'         => $dados['local'],
            'ckl_data'          => $dados['data'],
            'ckl_hodometro'     => $dados['hodometro'],
            'ckl_cliente'       => $dados['cliente'],
            'ckl_responsavel'   => $dados['responsavel'],
        );
        $this->db->insert('checklistNovo', $a);    
        $id = $this->db->insert_id();    
        
        $a['ckl_id'] = $id;
        $a['ckl_token'] = md5($id);
        
        $this->db->where('ckl_id', $id);
        $this->db->update('checklistNovo', $a);
        
        $b = $this->categoriaDiv($dados['guia']);
        $data = array(
            'div'  => $b,
            'token'=> $a['ckl_token'],
            'guia' => $dados['guia']+1,
            );
        
        return $data;
    }
    
    public function step0(){
        
        $a = $this->categorias();
        $cont = 0;
        $helper = "";
        foreach($a as $as){
            $helper .= "<div id='".strtolower($as['categoria_nome_limpo'])."-part' class='content' role='tabpanel' aria-labelledby='".strtolower($as['categoria_nome_limpo'])."-part-trigger'>";
            $helper .= "Teste";
            $helper .= "</div>";
        }
        
        
        
            
        return $helper;
    }
    
    public function itens(){
        $this->db->select('item_id');
        $b = $this->db->get('itens')->result_array();
        return $b;
    }
    
    public function divs($id){
        $this->db->select('item_id, item_nome');
        $this->db->where('item_categoria_id', $id);
        $this->db->order_by('item_posicao', 'ASC');
        $b = $this->db->get('itens')->result_array();
        return $b;
    }
    
    public function divs2(){
        $a = $this->categorias();
        $html = array();
        $count = count($a);
        $line = 1;
        foreach($a as $cat){
            $this->db->select('item_id, item_nome');
            $this->db->where('item_categoria_id', $cat['categoria_id']);
            $this->db->order_by('item_posicao', 'ASC');
            $b = $this->db->get('itens')->result_array();
            $helper = "";
            foreach($b as $item){
                $helper .= "<div class='row'>
                                <div class='col-md-4'>
                                    <label for='".$item['item_id']."-confirm'>Item - ".$item['item_nome'].":</label><br>
                                    <input type='checkbox' id='".$item['item_id']."-confirm' name='".$item['item_id']."-confirm' checked data-bootstrap-switch data-off-color='danger' data-on-color='success' data-on-text='Confere' data-off-text='Problema'>
                                </div>
                                <div class='col-md-4'>
                                    <label for='".$item['item_id']."-obs'>Observacao - ".$item['item_nome'].":</label>
                                    <p><input type='text' id='".$item['item_id']."-obs' name='".$item['item_id']."-obs'></p>
                                </div>
                                
                            </div>
                            <hr size='8' width='90%' color='red'>";
                            /*<div class='col-md-4'>
                                    <label for='".$item['item_id']."-file'>Foto - ".$item['item_nome'].":</label>
                                    <input type='file' id='".$item['item_id']."-file' name='".$item['item_id']."-file'>
                            </div>*/
            }
            
            if($line+1 > $count){
                $helper .= "<hr><button type='button' class='btn btn-primary' onclick='last()'>Finalizar</button>";
            }else{
                $helper .="<button type='button' class='btn btn-primary' onclick='stepper.previous()'>Anterior</button>
                            <button type='button' class='btn btn-primary' onclick='stepper.next()'>Proximo</button>";
            }
            $line++;
            $html[$cat['categoria_id']] = $helper;
        }
        return $html;
    }
    
    public function checklistItens($dados){
        $a = $this->itens();
        $itens = $ids = "";
        foreach($a as $item){
            if(!empty($itens)){
                $itens .= "|";
                $ids .=  "|";
            }
            
            if(array_key_exists($item['item_id']."-confirm", $dados) && $dados[$item['item_id']."-confirm"] == "on"){
                $itens .= "S";
            }else{
                $itens .= "N";
            }
            $ids .= $item['item_id'];
        }
        
        $this->db->where('ckl_token', $dados['token']);
        $a = $this->db->get('checklistNovo')->row_array();
        
        if(md5($a['ckl_id']) == $dados['token']){
            $aux = array(
                'cki_chl_id'    => $a['ckl_id'],
                'cki_token'     => $dados['token'],
                'cki_itens'     => $ids,
                'cki_situacao'  => $itens,
                );
            $this->db->insert('chklistItens', $aux);
            $data = array(
                'erro'  => 0,
                'msg'   => "Checklist concluido com sucesso!",
            );
        }else{
            $data = array(
                'erro'  => 1,
                'msg'   => "Falha na gravacao, tente novamente em instantes!",
            );
        }
        return $data;
    }
    
}
