<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Valerefeicaomodel extends CI_Model{
    
    public function getAll(){

        $this->db->select('valerefeicao.*, motoristas.motorista_nome, fornecedores.fornecedor_nome');
        $this->db->from('valerefeicao');
        $this->db->join('motoristas', 'valerefeicao.vr_motorista_id = motoristas.motorista_id');
        $this->db->join('fornecedores', 'valerefeicao.vr_fornecedor_cnpj = fornecedores.fornecedor_cnpj');
        
        $query = $this->db->get()->result_array();

        // Retorna os resultados
        return $query;
    }

    public function getValeRefeicaoFiltered($filter)
    {

        $this->db->select('valerefeicao.*, motoristas.motorista_nome, fornecedores.fornecedor_nome');
        $this->db->from('valerefeicao');
        $this->db->join('motoristas', 'valerefeicao.vr_motorista_id = motoristas.motorista_id');
        $this->db->join('fornecedores', 'valerefeicao.vr_fornecedor_cnpj = fornecedores.fornecedor_cnpj');

        // Filtros de data e status
        if (!empty($filter['inicio'])) {
            $this->db->where('valerefeicao.vr_data_validade >=', $filter['inicio']);
        }
        if (!empty($filter['fim'])) {
            $this->db->where('valerefeicao.vr_data_validade <=', $filter['fim']);
        }
        
        if (!empty($filter['motorista_id'] && $filter['motorista_id'] != 'todas')) {
            $this->db->where('valerefeicao.vr_motorista_id', $filter['motorista_id']);
        }

        if (!empty($filter['fornecedor_cnpj'] && $filter['fornecedor_cnpj'] != 'todas')) {
            $this->db->where('valerefeicao.vr_fornecedor_cnpj', $filter['fornecedor_cnpj']);
        }

        $query = $this->db->get()->result_array();

        // Retorna os resultados
        return $query;
    }
    
    public function getAllAtivo(){
        $this->db->where('frota_ativo_id', 1);
        $data = $this->db->get('valerefeicao');
        return $data->result_array();
    }
	
	public function getById($id){
	    $this->db->where('vr_id', $id);
	    $userid = $this->db->get('valerefeicao');
	    return $userid->row_array();
	}
	
	public function getRowById($id){
	    $this->db->where('vr_id', $id);
	    $userid = $this->db->get('valerefeicao');
	    return $userid->row_array();
	}
	
    public function getMotoristas(){
        $data = $this->db->get('motoristas');
        return $data->result_array();
    }

    public function getFornecedores(){
        $data = $this->db->get('fornecedores');
        return $data->result_array();
    }

    public function addItem($dados){
        $this->db->insert('valerefeicao', $dados);
    }

    public function updateItem($id, $dados){
        $this->db->where('vr_id', $id);
        $this->db->update('valerefeicao', $dados);
    }

    public function get_last_item()
    {

        $this->db->order_by('vr_id', 'DESC');
        $query = $this->db->get('valerefeicao', 1);

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return null;
        }
    }

    public function deletarItem($id){
        $this->db->where('vr_id', $id);
        $this->db->delete('valerefeicao');
    }
}