<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Ticketpesagemmodel extends CI_Model{
    
    public function getAll(){

        $this->db->select('ticketpesagem.*, motoristas.motorista_nome, clientes.cliente_nome, clientes.cliente_nome, produtos.produto_nome');
        $this->db->from('ticketpesagem');
        $this->db->join('motoristas', 'ticketpesagem.tk_motorista_id = motoristas.motorista_id');
        $this->db->join('clientes', 'ticketpesagem.tk_cliente_cpfcnpj = clientes.cliente_cpfcnpj');
        $this->db->join('produtos', 'ticketpesagem.tk_item_id = produtos.produto_id');
        
        $query = $this->db->get()->result_array();

        // Retorna os resultados
        return $query;
    }

    public function getticketpesagemFiltered($filter)
    {

        $this->db->select('ticketpesagem.*, motoristas.motorista_nome, clientes.cliente_nome, produtos.produto_nome');
        $this->db->from('ticketpesagem');
        $this->db->join('motoristas', 'ticketpesagem.tk_motorista_id = motoristas.motorista_id');
        $this->db->join('clientes', 'ticketpesagem.tk_cliente_cpfcnpj = clientes.cliente_cpfcnpj');
        $this->db->join('produtos', 'ticketpesagem.tk_item_id = produtos.produto_id');

        // Filtros de data e status
        if (!empty($filter['inicio'])) {
            $this->db->where('ticketpesagem.tk_data >=', $filter['inicio']);
        }
        if (!empty($filter['fim'])) {
            $this->db->where('ticketpesagem.tk_data <=', $filter['fim']);
        }
        
        if (!empty($filter['motorista_id'] && $filter['motorista_id'] != 'todas')) {
            $this->db->where('ticketpesagem.tk_motorista_id', $filter['motorista_id']);
        }

        if (!empty($filter['veiculo_id'] && $filter['veiculo_id'] != 'todas')) {
            $this->db->where('ticketpesagem.tk_veiculo_id', $filter['veiculo_id']);
        }

        if (!empty($filter['item_id'] && $filter['item_id'] != 'todas')) {
            $this->db->where('ticketpesagem.tk_item_id', $filter['item_id']);
        }

        if (!empty($filter['cliente_cpfcnpj'] && $filter['cliente_cpfcnpj'] != 'todas')) {
            $this->db->where('ticketpesagem.tk_cliente_cpfcnpj', $filter['cliente_cpfcnpj']);
        }

        $query = $this->db->get()->result_array();

        // Retorna os resultados
        return $query;
    }
    
    public function getAllAtivo(){
        $this->db->where('frota_ativo_id', 1);
        $data = $this->db->get('ticketpesagem');
        return $data->result_array();
    }
	
	public function getById($id){
	    $this->db->where('tk_id', $id);
	    $userid = $this->db->get('ticketpesagem');
	    return $userid->row_array();
	}
	
	public function getRowById($id){
	    $this->db->where('tk_id', $id);
	    $userid = $this->db->get('ticketpesagem');
	    return $userid->row_array();
	}
	
    public function getMotoristas(){
        $data = $this->db->get('motoristas');
        return $data->result_array();
    }

    public function getFornecedores(){
        $data = $this->db->get('fornecedores');
        return $data->result_array();
    }

    public function getClientes(){
        $data = $this->db->get('clientes');
        return $data->result_array();
    }

    public function getProdutos(){
        $data = $this->db->get('produtos');
        return $data->result_array();
    }

    public function addItem($dados){
        $this->db->insert('ticketpesagem', $dados);
    }

    public function updateItem($id, $dados){
        $this->db->where('tk_id', $id);
        $this->db->update('ticketpesagem', $dados);
    }

    public function get_last_item()
    {

        $this->db->order_by('tk_id', 'DESC');
        $query = $this->db->get('ticketpesagem', 1);

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return null;
        }
    }

    public function deletarItem($id){
        $this->db->where('tk_id', $id);
        $this->db->delete('ticketpesagem');
    }

    public function deleteAnexo($id, $dados){
        $this->db->where('tk_id', $id);
        $this->db->update('ticketpesagem', $dados);
    }
}