<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Oleomodel extends CI_Model{
    
    public function updateTrocas($dados){
        $this->db->insert('troca_oleo', $dados);
        
        $this->db->where('frota_id', $dados['troca_oleo_frota_id']);
        $a = $this->db->get('frota')->row_array();
        
        if($a['frota_km'] < $dados['troca_oleo_km']){
            $a['frota_km'] = $dados['troca_oleo_km'];
            
            $this->db->where('frota_id', $dados['troca_oleo_frota_id']);
            return $this->db->update('frota',$a);
        }else{
            return true;
        }
    }
    
    public function getFrotaListAtiva(){
        $this->db->select('frota_id, frota_placa, frota_codigo, frota_km');
        $this->db->where('frota_ativo_id', 1);
        $a = $this->db->get('frota')->result_array();
        
        for($i=0; $i<count($a); $i++){
            $this->db->where('troca_oleo_frota_id', $a[$i]['frota_id']);
            $this->db->order_by('troca_oleo_id', 'DESC');
            $b = $this->db->get('troca_oleo')->row_array();
            
            $alert = $trocaOleo = $trocaKm = $trocaProx = null;
            
            if(!empty($b)){
                if((int)$b['troca_oleo_km'] > (int)($b['troca_oleo_proximo']-(int)1000)){
                    if((int)$b['troca_oleo_km'] > (int)$b['troca_oleo_proximo']){
                        $alert = "style='background-color: red;'";
                    }else{
                        $alert = "style='color: red;'";
                    }
                }else if((int)$a[$i]['frota_km'] > (int)($b['troca_oleo_proximo']-(int)500)){
                    if((int)$a[$i]['frota_km'] > (int)$b['troca_oleo_proximo']){
                        $alert = "style='background-color: red;'";
                    }else{
                        $alert = "style='color: red;'";
                    }
                }else{
                    $alert = "";
                }
                
                $trocaOleo = $b['troca_oleo_data'];
                $trocaKm = $b['troca_oleo_km'];
                $trocaProx = $b['troca_oleo_proximo'];
                
            }
            
            $frota[$i] = array(
                'frota'         => $a[$i]['frota_placa']." - ".$a[$i]['frota_codigo'],
                'lastChange'    => $this->formatValidData($trocaOleo),
                'lastKm'        => $this->formatValidKm($trocaKm),
                'km'            => $this->formatValidKm($a[$i]['frota_km']),
                'nextChange'    => $this->formatValidKm($trocaProx),
                'id'            => $a[$i]['frota_id'],
                'alert'         => $alert,
                );
                
            
        }
        return $frota;
    }
    
    function formatValidData($data){
        if($data == "" || $data == null){
            $data = "**/**/****";
        }else{
            $data = date("d/m/Y", strtotime($data));
        }
        return $data;
    }
    
    function formatValidKm($data){
        if($data == "" || $data == null){
            $data = "--";
        }else{
            $data = number_format($data, 0, ',', ' ');
        }
        return $data;
    }
    
}