<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Abastecimentomodel extends CI_Model
{

    public function getAll()
    {

        $this->db->select('abastecimentos.*, motoristas.motorista_nome, fornecedores.fornecedor_nome');
        $this->db->from('abastecimentos');
        $this->db->join('motoristas', 'abastecimentos.abst_motorista_id = motoristas.motorista_id');
        $this->db->join('fornecedores', 'abastecimentos.abst_fornecedor_cnpj = fornecedores.fornecedor_cnpj');

        $query = $this->db->get()->result_array();

        // Retorna os resultados
        return $query;
    }

    public function getAllAtivo()
    {
        $this->db->where('frota_ativo_id', 1);
        $data = $this->db->get('abastecimentos');
        return $data->result_array();
    }

    public function getById($id)
    {
        $this->db->where('abst_id', $id);
        $userid = $this->db->get('abastecimentos');
        return $userid->row_array();
    }

    public function getRowById($id)
    {
        $this->db->where('abst_id', $id);
        $userid = $this->db->get('abastecimentos');
        return $userid->row_array();
    }

    public function getMotoristas()
    {
        $data = $this->db->get('motoristas');
        return $data->result_array();
    }

    public function getFornecedores()
    {
        $data = $this->db->get('fornecedores');
        return $data->result_array();
    }

    public function addItem($dados)
    {
        $this->db->insert('abastecimentos', $dados);
    }

    public function updateItem($id, $dados)
    {
        $this->db->where('abst_id', $id);
        $this->db->update('abastecimentos', $dados);
    }

    public function quitarAbastecimento($id)
    {
        $this->db->where('abst_solicitacao_abastecimento_id', $id);
        $this->db->update('abastecimentos', array('abst_quitada' => "Sim"));
    }

    public function get_last_item()
    {

        $this->db->order_by('abst_id', 'DESC');
        $query = $this->db->get('abastecimentos', 1);

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return null;
        }
    }

    public function getAbastecimentosFiltered($filter)
    {

        $this->db->select('abastecimentos.*, motoristas.motorista_nome, fornecedores.fornecedor_nome');
        $this->db->from('abastecimentos');
        $this->db->join('motoristas', 'abastecimentos.abst_motorista_id = motoristas.motorista_id');
        $this->db->join('fornecedores', 'abastecimentos.abst_fornecedor_cnpj = fornecedores.fornecedor_cnpj');
        $this->db->order_by('abastecimentos.abst_id', 'DESC');

        // Filtros de data e status
        if (!empty($filter['inicio'])) {
            $this->db->where('abastecimentos.abst_data_hora >=', $filter['inicio']);
        }
        if (!empty($filter['fim'])) {
            $this->db->where('abastecimentos.abst_data_hora <=', $filter['fim']);
        }
        if (!empty($filter['quitada'] && $filter['quitada'] != 'todas')) {
            $this->db->where('abastecimentos.abst_quitada', $filter['quitada']);
        }

        if (!empty($filter['motorista_id'] && $filter['motorista_id'] != 'todas')) {
            $this->db->where('abastecimentos.abst_motorista_id', $filter['motorista_id']);
        }

        if (!empty($filter['fornecedor_cnpj'] && $filter['fornecedor_cnpj'] != 'todas')) {
            $this->db->where('abastecimentos.abst_fornecedor_cnpj', $filter['fornecedor_cnpj']);
        }

        $query = $this->db->get()->result_array();

        // Retorna os resultados
        return $query;
    }

    public function deletarItem($id)
    {
        $this->db->where('abst_id', $id);
        $this->db->delete('abastecimentos');
    }

    public function deleteAnexo($id, $dados){
        $this->db->where('abst_id', $id);
        $this->db->update('abastecimentos', $dados);
    }
}
