<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Valerefeicao extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('valerefeicaomodel');
    }

    public function itens()
    {
        $this->acessorestrito("VALE REFEIÇÃO");

        $pag = '9.1';
        $titulo = 'LISTAGEM DE VALE REFEIÇÃO';
        $raiz = '#';
        $local = 'Vale Refeição';
        $funcao = 'Itens';

        $valerefeicao = $this->valerefeicaomodel->getAll();
        $motoristas = $this->valerefeicaomodel->getMotoristas();
        $fornecedores = $this->valerefeicaomodel->getFornecedores();

        $data['itens'] = $valerefeicao;
        $data['motoristas'] = $motoristas;
        $data['fornecedores'] = $fornecedores;


        $this->header($pag, $titulo, $raiz, $local, $funcao);
        $this->load->view('valerefeicao/listagem', $data);
        $this->footer();
    }

    public function novoitem()
    {
        $dados = array(
            'vr_data_validade'      => $this->input->post('vr_data_validade'),
            'vr_motorista_id'    => $this->input->post('vr_motorista_id'),
            'vr_fornecedor_cnpj'   => $this->input->post('vr_fornecedor_cnpj'),
            'vr_quantidade'      =>  '1',//$this->input->post('vr_quantidade'),
            'vr_valor'           => $this->input->post('vr_valor'),
            'vr_descricao'       => $this->input->post('vr_descricao'),
            'vr_protocolo'       => $this->input->post('vr_protocolo'),
        );

        if ($this->input->post('vr_id') != null) {
            $id = $this->input->post('vr_id');
            $this->valerefeicaomodel->updateItem($id, $dados);
            redirect(base_url('valerefeicao'));
        } else {

            $last_item = $this->valerefeicaomodel->get_last_item();
            $vr_solicitacao_id = $last_item[0]['vr_solicitacao_id'];
            $aux_num = str_replace('VR', '', $vr_solicitacao_id );

            if (isset($vr_solicitacao_id)) {
                $dados['vr_solicitacao_id'] = $this->numZero( (int)$aux_num + 1 );
            } else {
                $dados['vr_solicitacao_id'] = $this->numZero(1);
            }

            $this->valerefeicaomodel->addItem($dados);
            redirect(base_url('valerefeicao'));
        }
    }

    function numZero($valor)
    {
        if ($valor < 10) {
            $valor = "VR000000" . $valor;
        } else if ($valor < 100) {
            $valor = "VR00000" . $valor;
        } else if ($valor < 1000) {
            $valor = "VR0000" . $valor;
        } else if ($valor < 10000) {
            $valor = "VR000" . $valor;
        } else if ($valor < 100000) {
            $valor = "VR00" . $valor;
        } else if ($valor < 1000000) {
            $valor = "VR0" . $valor;
        }
        return $valor;
    }

    function deletar(){
        $this->valerefeicaomodel->deletarItem($this->input->post('vr_id'));
        redirect(base_url('valerefeicao'));
    }
}
