<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Checklist extends MY_Controller {

        function novacategoria(){
            $this->load->database();
            $this->load->model('checklistmodel');
            $dados = array(
                'categoria_nome'        => $this->input->post('categoria'),
                'categoria_posicao'     => $this->input->post('importancia'),
                );
            $this->checklistmodel->addCategoria($dados);
            redirect(base_url('checkitens'));
        }
        
        function novoitem(){
            $this->load->database();
            $this->load->model('checklistmodel');
            
            if($this->input->post('foto') == null){
                $foto = 0;
            }else{
                $foto = $this->input->post('foto');
            }
            
            $dados = array(
                'item_nome'         => $this->input->post('item'),
                'item_posicao'      => $this->input->post('importancia'),
                'item_categoria_id' => $this->input->post('categoria_id'),
                'item_foto'         => $foto,
                );
            $this->checklistmodel->addItem($dados);
            redirect(base_url('checkitens'));
        }
        
        function desativar(){
            $this->load->database();
            $this->load->model('checklistmodel');
            $this->checklistmodel->removeitem($this->input->post('funcao_id'));
            redirect(base_url('checkitens'));
        }
        
        function reativar(){
            $this->load->database();
            $this->load->model('checklistmodel');
            $aux = $this->checklistmodel->getItensById($this->input->post('funcao_idatv'));
            $aux['item_ativo'] = 1;
            $this->checklistmodel->updateItens($aux);
            redirect(base_url('checkitens'));
        }
        
        function chave(){
            $this->load->database();
            $this->load->model('checklistmodel');
            $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuwxyz0123456789-_";
            $string = '';
            for($i = 0; $i < 10; $i++){
                $string .= $chars[mt_rand(0,62)];
            }
            
            $date = date('Y-m-d H:m:s');
            
            $chave = $date.$string;
            
            for($i= 0; $i < 10; $i++){
                $chave = hash('md5', $chave);
            }
            
            if($this->checklistmodel->getChave($chave) != ""){
                $this->chave();
            }else{
                return $chave;
            }
        }
        
        function novochecklist(){
            $this->load->database();
            $this->load->model('checklistmodel');
            
            $item = "";
            $itens = $this->input->post('itens');
            for($i=0; $i<count($itens); $i++){
                $item .= $itens[$i];
                if(isset($itens[$i+1])){
                $item .= "|";
                }
            }
            
            $chave = $this->input->post('chave');
            
            $Z = $this->checklistmodel->retriveActiveKey($chave);
            
            if($Z == 0 || $Z == null){
                $dados = array(
                    'checklist_cliente'     => $this->input->post('cliente'),
                    'checklist_frota'       => $this->input->post('frota'),
                    'checklist_elementos'   => $item,
                    'checklist_chave'       => $chave,
                    'checklist_fotos'       => "",
                    'checklist_finalizada'  => 0,
                    );
                $this->checklistmodel->addChecklist($dados);
                redirect(base_url('checkgerar'));
            }else{
                $this->session->set_userdata('erro', 1);
                redirect(base_url('checkgerar'));
            }
        }
        
        public function itens(){
            $this->acessorestrito("CHECKLIST");
            
            $pag = '7.1';
            $titulo = 'LISTA DE ITENS';
            $raiz = '#';
            $local = 'CheckList';
            $funcao = 'Itens';
            
            $this->load->database();
            $this->load->model('checklistmodel');
            
            $itens = $this->checklistmodel->getItens();
            for($i=0; $i<count($itens); $i++){
                
                $aux = $this->checklistmodel->getCategoriasById($itens[$i]['item_categoria_id']);
                $itens[$i]['item_categoria_id'] = $aux['categoria_nome'];
            }
            
            $data = array(
                'erro' => null,
                'itens' => $itens,
                'categorias' => $this->checklistmodel->getCategorias(),
                );
            
            $this->header($pag, $titulo, $raiz, $local, $funcao);
            $this->load->view('checklist/listagem', $data);
            $this->footer();
        }
        
        public function gerar(){
            $this->acessorestrito("CHECKLIST");
            
            $pag = '7.2';
            $titulo = 'CHECKLISTS';
            $raiz = '#';
            $local = 'CheckList';
            $funcao = 'CheckList';
            
            $this->load->database();
            $this->load->model('checklistmodel');
            
            $itens = $this->checklistmodel->getItens();
            for($i=0; $i<count($itens); $i++){
                
                $aux = $this->checklistmodel->getCategoriasById($itens[$i]['item_categoria_id']);
                $itens[$i]['item_categoria_id'] = $aux['categoria_nome'];
            }
            
            $checks = $this->checklistmodel->getChecklistsAtivo();
            $itens = $this->checklistmodel->getItens();
            $categorias = $this->checklistmodel->getCategorias();
            $clientes = $this->checklistmodel->getClientes();
            $chave = $this->chave();
            $frota = $this->checklistmodel->getFrota();
            
            for($i=0; $i<count($checks);$i++){
                foreach($clientes as $cli){
                    if($checks[$i]['checklist_cliente'] == $cli['cliente_cpfcnpj']){
                        $checks[$i]['checklist_cliente'] = $cli['cliente_nome'];
                    }
                }
                foreach($frota as $frt){
                    if($checks[$i]['checklist_frota'] == $frt['frota_id']){
                        $checks[$i]['checklist_frota'] = $frt['frota_codigo'];
                    }
                }
            }

            $data = array(
                'erro'      => null,
                'itens'     => $itens,
                'categorias'=> $categorias,
                'clientes'  => $clientes,
                'chave'     => $this->chave(),
                'frota'     => $frota,
                'checklists'=> $checks,
                );
                
            $this->header($pag, $titulo, $raiz, $local, $funcao);
            $this->load->view('checklist/gerachecklist', $data);
            $this->footer();
        }
        
        public function preencher(){
            $this->acessorestrito("CHECKLIST");
            
            $pag = '7.3';
            $titulo = 'CHECKLISTS';
            $raiz = '#';
            $local = 'CheckList';
            $funcao = 'CheckList';
            
            $this->load->database();
            $this->load->model('checklistmodel');
            
            $data = array(
                'erro' => null,
                );
            
            
            $this->header($pag, $titulo, $raiz, $local, $funcao);
            $this->load->view('checklist/checklist', $data);
            $this->footer();
            
        }
        
        public function lista($id=null){
            $this->load->database();
            $this->load->model('checklistmodel');
            
            $check = $this->checklistmodel->getChecklistsByKey($id);
            $frota = $this->checklistmodel->getfrotaById($check['checklist_frota']);
            
            $checkitem = explode("|", $check['checklist_elementos']);
            
            for($i=0; $i<count($checkitem); $i++){
                $itm = $this->checklistmodel->getItensById($checkitem[$i]);
                $itens[$i] = array(
                    'item_id'               => $itm['item_id'],
                    'item_categoria_id'     => $itm['item_categoria_id'],
                    'item_categoria'        => $this->checklistmodel->getCategoriaNameById($itm['item_categoria_id']),
                    'item_nome'             => $itm['item_nome'],
                    'item_foto'             => $itm['item_foto'],
                    );
            }

            $data = array(
                'id'        => $id,
                'local'     => "",
                'data'      => date('d-m-Y'),
                'placa'     => $frota['frota_placa'],
                'hodômetro' => $frota['frota_km'],
                'itens'     => $itens,
                'categorias'=> $this->checklistmodel->getCategorias(),
                );
            $this->load->view('recursos/headerSimples');   
            $this->load->view('checklist/list', $data);
            $this->load->view('recursos/footerSimples');
        }
        
        public function listagem(){
            $this->acessorestrito("CHECKLIST");
            
            $pag = '7.4';
            $titulo = 'CHECKLISTS FINALIZADOS';
            $raiz = '#';
            $local = 'CheckList';
            $funcao = 'CheckList';
            
            $this->load->database();
            $this->load->model('checklistmodel');
            
            $itens = $this->checklistmodel->getItens();
            for($i=0; $i<count($itens); $i++){
                
                $aux = $this->checklistmodel->getCategoriasById($itens[$i]['item_categoria_id']);
                $itens[$i]['item_categoria_id'] = $aux['categoria_nome'];
            }
            
            $checks = $this->checklistmodel->getChecklistsCompleto();
            $itens = $this->checklistmodel->getItens();
            $categorias = $this->checklistmodel->getCategorias();
            $clientes = $this->checklistmodel->getClientes();
            $chave = $this->chave();
            $frota = $this->checklistmodel->getFrota();
            
            for($i=0; $i<count($checks);$i++){
                foreach($clientes as $cli){
                    if($checks[$i]['checklist_cliente'] == $cli['cliente_cpfcnpj']){
                        $checks[$i]['checklist_cliente'] = $cli['cliente_nome'];
                    }
                }
                foreach($frota as $frt){
                    if($checks[$i]['checklist_frota'] == $frt['frota_id']){
                        $checks[$i]['checklist_frota'] = $frt['frota_codigo'];
                    }
                }
            }

            $data = array(
                'erro'      => null,
                'itens'     => $itens,
                'categorias'=> $categorias,
                'clientes'  => $clientes,
                'chave'     => $this->chave(),
                'frota'     => $frota,
                'checklists'=> $checks,
                );
                
            $this->header($pag, $titulo, $raiz, $local, $funcao);
            $this->load->view('checklist/listcheck', $data);
            $this->footer();
        }
        
        public function visualizar(){
            $this->load->database();
            $this->load->model('checklistmodel');
            $a = $this->checklistmodel->checklistCompleto($this->input->post('checklist_id'));
            
            $this->load->view('checklist/listacompleta', $a);
            
        }
        
        public function novaCheckList(){
            $this->acessorestrito("CHECKLIST");
            
            $this->load->database();
            $this->load->model('checklistmodel');
            
            
            $data = array(
                'cinterna'      => $this->checklistmodel->get(3),
                'seletrico'     => $this->checklistmodel->get(4),
                'cexterna'      => $this->checklistmodel->get(5),
                'pneu'          => $this->checklistmodel->get(6),
                'carroceria'    => $this->checklistmodel->get(7),
                'csuplementar'  => $this->checklistmodel->get(8),
                'clientes'      => $this->checklistmodel->getClientes(),
                'frota'         => $this->checklistmodel->getFrota(),
            );
                
            $this->header(7.4, 'CHECKLISTS FINALIZADOS', '#', 'Checklist', 'Checklist');
            $this->load->view('checklist/checklistnova', $data);
            $this->footer();
        }
        
        public function verificarChave(){
            $this->load->database();
            $this->load->model('checklistmodel');
            
            $chave = $this->checklistmodel->getChecklistsByKey($this->input->post('chave'));
            
            if($chave){
                echo json_encode(true);
            } else {
                echo json_encode(false);
            }
        }
        
        public function novocklist(){
            $pag = '7';
            $titulo = 'CHECKLIST';
            $raiz = '#';
            $local = 'CheckList';
            $funcao = 'CheckList';
            
            $this->load->model('checklistmodel');
            $data['steps']      = $this->checklistmodel->categorias();
            $data['frota']      = $this->checklistmodel->frota();
            //$data['html']       = $this->checklistmodel->divs();
            $data['cliente']    = $this->checklistmodel->cliente();
            foreach($data['steps'] as $cat){
                $data[$cat['categoria_nome_limpo']] = $this->checklistmodel->divs($cat['categoria_id']);
            }
            
            $this->header($pag, $titulo, $raiz, $local, $funcao);
            $this->load->view('checklist/advanced', $data);
            $this->footer();
        }
        
        function step1(){
            $this->load->model('checklistmodel');
            $data = $this->checklistmodel->step1($_POST);
            echo json_encode($data);
        }
        function steps(){
            $this->load->model('checklistmodel');
            $helper = $this->checklistmodel->itens();
            
            foreach($helper as $hlp){
                if($_FILES[$hlp['item_id'].'-file']['size'] > 0){
                    $this->do_upload($_POST['token'], $_FILES[$hlp['item_id'].'-file'], $hlp['item_id']);
                }
            }
            
            $data = $this->checklistmodel->checklistItens($_POST);
            
            echo json_encode($data);
        }
        
        public function do_upload($folder, $file, $name){

                $patch = './imagens/'.$folder.'/';
                
                if(!is_dir($patch)){
                   mkdir($patch);
                }
                $ext = explode(".", $file['name']);
                
                $config['upload_path']          = $patch;
                $config['upload_path']          = $patch;
                $config['allowed_types']        = '*';
                $config['file_name']            = $name.".".end($ext);
                $config['overwrite']            = TRUE;
                
                $this->load->library('upload', $config);
               
               
                if(!$this->upload->do_upload($name.'-file')){
                    $error = array('error' => $this->upload->display_errors());
                    print_r($error);
                }else{
                    $data = array('upload_data' => $this->upload->data());
                    /*$source_path = $data['full_path'];
                    $target_path = $data['file_path'];
                    $config_manip = array(
                        'image_library' => 'gd2',
                        'source_image' => $source_path,
                        'new_image' => $target_path,
                        'maintain_ratio' => TRUE,
                        'width' => 500,
                        );
                
                    $this->load->library('image_lib', $config_manip);
                    if (!$this->image_lib->resize()) {
                        echo $this->image_lib->display_errors();
                    }
                    $this->image_lib->clear();*/
                }
        }
                //Criado dia 16/07/20122
                //função criada para o upload da imagem a ser trabalhada na tela de checklist

                public function upload_img(){
                
                //if($_POST == true ){
                    $folder = $_POST['folder'];
                    //$file   = $_POST['file'];
                    //$name   = $_POST['name'];
                 //}
                print_r($_POST);
                //colocando variavel do caminho de forma direta
                $patch = './imagens/'.$folder.'/';
                //$patch = './imagens/checklist/';
                
                        if(!is_dir($patch)){
                            mkdir($patch);
                        }
                        $ext = explode(".", $_FILES['file'] ['type']);
                        
                        $config['upload_path']          = $patch;
                        $config['upload_path']          = $patch;
                        $config['allowed_types']        = '*';
                        //$config['file_name']            = $name.".".end($ext);
                        $config['overwrite']            = TRUE;
                        
                        $this->load->library('upload', $config);


                        //if(!$this->upload->do_upload($_FILES['file']))
                        if(!$this->upload->do_upload('file')){
                            $error = array('error' => $this->upload->display_errors());
                            print_r($error);
                        }else{
                            $data = array('upload_data' => $this->upload->data());
                            /*$source_path = $data['full_path'];
                            $target_path = $data['file_path'];
                            $config_manip = array(
                                'image_library' => 'gd2',
                                'source_image' => $source_path,
                                'new_image' => $target_path,
                                'maintain_ratio' => TRUE,
                                'width' => 500,
                                );
                        
                            $this->load->library('image_lib', $config_manip);
                            if (!$this->image_lib->resize()) {
                                echo $this->image_lib->display_errors();
                            }
                            $this->image_lib->clear();*/
                        }
        }
        
        public function visualizar2(){
            $this->load->database();
            $this->load->model('checklistmodel');
            $a = $this->checklistmodel->checklistCompleto($this->input->post('checklist_id'));
            
            $this->load->view('checklist/listacompleta2', $a);
            
        }
        
        public function listacheckNovo(){
            $pag = '7';
            $titulo = 'CHECKLIST';
            $raiz = '#';
            $local = 'CheckList';
            $funcao = 'CheckList';
            
            $this->header($pag, $titulo, $raiz, $local, $funcao);
            $this->load->view('checklist/listagemNovo');
            $this->footer();
            
        }
        
        /*
        Função criada para gravar cada etapa do checklist
        */
        function steppers(){
            $this->load->model('checklistmodel');
            $data = $this->checklistmodel->steppers($_POST);
            echo json_encode($data);
        }
        
        public function listarCheckList(){
            $this->acessorestrito("CHECKLIST");
            
            $pag = '7.5';
            $titulo = 'CHECKLISTS';
            $raiz = '#';
            $local = 'CheckList';
            $funcao = 'CheckList';
            
            $this->load->database();
            $this->load->model('checklistmodel');
            
            $data['checklists'] = $this->checklistmodel->getCheckList();
                
            $this->header($pag, $titulo, $raiz, $local, $funcao);
            $this->load->view('checklist/listachklst', $data);
            $this->footer();
            
        }
        
        function verCheckList($id){
            $this->load->model('checklistmodel');
            $aux = $this->checklistmodel->token($id);
            
            $dirname = base_url('imagens/').$aux['ckl_token'];
            
            $hlp = 0;
            $path = 'imagens'.DIRECTORY_SEPARATOR.$aux['ckl_token'].DIRECTORY_SEPARATOR;
            foreach (glob($path."*.*") as $file) {
                $pics[$hlp] = $file;
                $hlp++;
            }
            
            $data = array(
                'token'         => $aux['ckl_id'],
                'cliente'       => $this->checklistmodel->getClienteId($aux['ckl_cliente']),
                'data'          => date("d/m/Y", strtotime($aux['ckl_data'])),
                'local'         => $aux['ckl_local'],
                'frota'         => $this->checklistmodel->getFrotaId($aux['ckl_frota_id']),
                'hodometro'     => $aux['ckl_hodometro'],
                'responsavel'   => $aux['ckl_responsavel'],
                'itens'         => $this->checklistmodel->getItensToken($aux['ckl_token']),
                'imagens'       => $pics,
            );
            
            $this->load->view('checklist/pdfChkLst', $data);
        }
        
        public function editaChkList($id){
            $pag = '7';
            $titulo = 'CHECKLIST';
            $raiz = '#';
            $local = 'CheckList';
            $funcao = 'CheckList';
            
            $this->load->model('checklistmodel');
            $data['steps']      = $this->checklistmodel->categorias();
            $data['frota']      = $this->checklistmodel->frota();
            $data['cliente']    = $this->checklistmodel->cliente();
            foreach($data['steps'] as $cat){
                $data[$cat['categoria_nome_limpo']] = $this->checklistmodel->divs($cat['categoria_id']);
            }
            
            $data['check'] = $this->checklistmodel->token($id);
            $data['token'] = $data['check']['ckl_token'];
            $data['itens'] = $this->checklistmodel->retrieveItens($data['check']['ckl_token']);
            
            $this->header($pag, $titulo, $raiz, $local, $funcao);
            $this->load->view('checklist/editChk', $data);
            $this->footer();
        }
}   